/*
 * Decompiled with CFR 0.152.
 */
package io.eventuate.local.java.jdbckafkastore;

import io.eventuate.Command;
import io.eventuate.EntityWithIdAndVersion;
import io.eventuate.EntityWithMetadata;
import io.eventuate.EventWithMetadata;
import io.eventuate.SaveOptions;
import io.eventuate.UpdateOptions;
import io.eventuate.example.banking.domain.Account;
import io.eventuate.example.banking.domain.AccountCommand;
import io.eventuate.example.banking.domain.CreateAccountCommand;
import io.eventuate.example.banking.domain.DebitAccountCommand;
import io.eventuate.local.java.jdbckafkastore.AccountMetadataEventHandler;
import io.eventuate.sync.AggregateRepository;
import io.eventuate.testutil.ReceivedEvent;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.junit.Assert;

public abstract class AbstractCommonJdbcEventMetadataAutoConfigurationIntegrationSyncTest {
    public void shouldCreateAccount() {
        AggregateRepository<Account, AccountCommand> accountRepository = this.getAccountRepository();
        AccountMetadataEventHandler accountMetadataEventHandler = this.getAccountMetadataEventHandler();
        Map<String, String> saveMetadata = Collections.singletonMap("xy", "z");
        EntityWithIdAndVersion saveResult = accountRepository.save((Command)new CreateAccountCommand(new BigDecimal("10.23")), Optional.of(new SaveOptions().withEventMetadata(saveMetadata)));
        EntityWithMetadata findResult = accountRepository.find(saveResult.getEntityId());
        Assert.assertEquals(Optional.of(saveMetadata), (Object)((EventWithMetadata)findResult.getEvents().get(0)).getMetadata());
        Map<String, String> updateMetadata = Collections.singletonMap("abc", "d");
        EntityWithIdAndVersion updateResult = accountRepository.update(saveResult.getEntityId(), (Command)new DebitAccountCommand(new BigDecimal("1.34"), null), Optional.of(new UpdateOptions().withEventMetadata(updateMetadata)));
        EntityWithMetadata findResult2 = accountRepository.find(saveResult.getEntityId());
        Assert.assertEquals(Optional.of(updateMetadata), (Object)((EventWithMetadata)findResult2.getEvents().get(1)).getMetadata());
        ReceivedEvent createEvent = accountMetadataEventHandler.eventuallyContains("accountMetadataEventHandler - save", saveResult.getEntityVersion());
        Assert.assertEquals(Optional.of(saveMetadata), (Object)createEvent.getEventMetadata());
        ReceivedEvent updateEvent = accountMetadataEventHandler.eventuallyContains("accountMetadataEventHandler - update", updateResult.getEntityVersion());
        Assert.assertEquals(Optional.of(updateMetadata), (Object)updateEvent.getEventMetadata());
    }

    protected abstract AggregateRepository<Account, AccountCommand> getAccountRepository();

    protected abstract AccountMetadataEventHandler getAccountMetadataEventHandler();
}

