/*
 * Decompiled with CFR 0.152.
 */
package io.eventuate.local.java.jdbckafkastore;

import io.eventuate.Aggregate;
import io.eventuate.Command;
import io.eventuate.EntityWithIdAndVersion;
import io.eventuate.EntityWithMetadata;
import io.eventuate.MissingApplyEventMethodStrategy;
import io.eventuate.Snapshot;
import io.eventuate.example.banking.domain.Account;
import io.eventuate.example.banking.domain.AccountCommand;
import io.eventuate.example.banking.domain.AccountSnapshotStrategy;
import io.eventuate.example.banking.domain.CreateAccountCommand;
import io.eventuate.example.banking.domain.DebitAccountCommand;
import io.eventuate.sync.AggregateRepository;
import java.math.BigDecimal;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import org.junit.Assert;
import org.mockito.Matchers;
import org.mockito.Mockito;

public abstract class AbstractCommonJdbcAutoConfigurationWithSnapshotsIntegrationTest {
    public void shouldCreateAndUpdateAccounts() throws ExecutionException, InterruptedException {
        AggregateRepository<Account, AccountCommand> accountRepository = this.getAccountRepository();
        AccountSnapshotStrategy accountSnapshotStrategy = this.getAccountSnapshotStrategy();
        ((AccountSnapshotStrategy)Mockito.verify((Object)accountSnapshotStrategy)).getAggregateClass();
        BigDecimal initialBalance = new BigDecimal(12345);
        BigDecimal debitAmount = new BigDecimal(12);
        EntityWithIdAndVersion saveResult = accountRepository.save((Command)new CreateAccountCommand(initialBalance));
        accountRepository.update(saveResult.getEntityId(), (Command)new DebitAccountCommand(debitAmount, null));
        ((AccountSnapshotStrategy)Mockito.verify((Object)accountSnapshotStrategy)).possiblySnapshot((Aggregate)Matchers.any(), (Optional)Matchers.any(), (List)Matchers.any(), (List)Matchers.any());
        EntityWithMetadata findResult = accountRepository.find(saveResult.getEntityId());
        Assert.assertEquals((Object)initialBalance.subtract(debitAmount), (Object)((Account)findResult.getEntity()).getBalance());
        ((AccountSnapshotStrategy)Mockito.verify((Object)accountSnapshotStrategy)).recreateAggregate((Class)Matchers.any(), (Snapshot)Matchers.any(), (MissingApplyEventMethodStrategy)Matchers.any());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{accountSnapshotStrategy});
    }

    protected abstract AggregateRepository<Account, AccountCommand> getAccountRepository();

    protected abstract AccountSnapshotStrategy getAccountSnapshotStrategy();
}

