/*
 * Decompiled with CFR 0.152.
 */
package io.eventuate.javaclient.eventdispatcher;

import io.eventuate.EndOfCurrentEventsReachedEvent;
import io.eventuate.EventHandlerMethod;
import io.eventuate.EventSubscriber;
import io.eventuate.EventuateAggregateStoreEvents;
import io.eventuate.EventuateSubscriptionFailedException;
import io.eventuate.RegisteredSubscription;
import io.eventuate.SubscriberOptions;
import io.eventuate.SubscriptionsRegistry;
import io.eventuate.javaclient.domain.EventDispatcher;
import io.eventuate.javaclient.domain.EventHandler;
import io.eventuate.javaclient.domain.EventHandlerProcessor;
import io.eventuate.javaclient.domain.SwimlaneBasedDispatcher;
import io.eventuate.javaclient.eventdispatcher.EventEntityUtil;
import io.eventuate.javaclient.eventhandling.exceptionhandling.EventDeliveryExceptionHandler;
import io.eventuate.javaclient.eventhandling.exceptionhandling.EventDeliveryExceptionHandlerManager;
import io.eventuate.javaclient.eventhandling.exceptionhandling.EventDeliveryExceptionHandlerManagerImpl;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.ReflectionUtils;

public class EventDispatcherInitializer {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private EventHandlerProcessor[] processors;
    private EventuateAggregateStoreEvents aggregateStore;
    private Executor executorService;
    private SubscriptionsRegistry subscriptionsRegistry;
    private Set<String> subscriberIds = new HashSet<String>();

    public EventDispatcherInitializer(EventHandlerProcessor[] processors, EventuateAggregateStoreEvents aggregateStore, Executor executorService, SubscriptionsRegistry subscriptionsRegistry) {
        this.processors = processors;
        this.aggregateStore = aggregateStore;
        this.executorService = executorService;
        this.subscriptionsRegistry = subscriptionsRegistry;
    }

    public void registerEventHandler(Object eventHandlerBean, String beanName, Class<?> beanClass) {
        this.logger.info("registering event handler: bean: {}, name: {}, class", new Object[]{eventHandlerBean, beanName, beanClass});
        List fieldsAndMethods = Stream.concat(Arrays.stream(ReflectionUtils.getUniqueDeclaredMethods(beanClass)), Arrays.stream(beanClass.getDeclaredFields())).collect(Collectors.toList());
        List annotatedCandidateEventHandlers = fieldsAndMethods.stream().filter(fieldOrMethod -> AnnotationUtils.findAnnotation((AnnotatedElement)fieldOrMethod, EventHandlerMethod.class) != null).collect(Collectors.toList());
        List<EventHandler> handlers = annotatedCandidateEventHandlers.stream().map(fieldOrMethod -> Arrays.stream(this.processors).filter(processor -> processor.supports(fieldOrMethod)).findFirst().orElseThrow(() -> new RuntimeException("Don't know what to do with fieldOrMethod " + fieldOrMethod)).process(eventHandlerBean, fieldOrMethod)).collect(Collectors.toList());
        if (handlers.isEmpty()) {
            throw new RuntimeException("No handlers defined for this class" + beanClass);
        }
        Map<String, Set<String>> aggregatesAndEvents = this.makeAggregatesAndEvents(handlers.stream().filter(handler -> !handler.getEventType().equals(EndOfCurrentEventsReachedEvent.class)).collect(Collectors.toList()));
        Map<Class<?>, EventHandler> eventTypesAndHandlers = this.makeEventTypesAndHandlers(handlers);
        List exceptionHandlers = Arrays.stream(beanClass.getDeclaredFields()).filter(this::isExceptionHandlerField).map(f -> {
            try {
                f.setAccessible(true);
                return (EventDeliveryExceptionHandler)f.get(eventHandlerBean);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList());
        EventSubscriber a = (EventSubscriber)AnnotationUtils.findAnnotation(beanClass, EventSubscriber.class);
        if (a == null) {
            throw new RuntimeException("Needs @EventSubscriber annotation: " + eventHandlerBean);
        }
        String subscriberId = StringUtils.isBlank((String)a.id()) ? beanName : a.id();
        EventDispatcher eventDispatcher = new EventDispatcher(subscriberId, eventTypesAndHandlers, (EventDeliveryExceptionHandlerManager)new EventDeliveryExceptionHandlerManagerImpl(exceptionHandlers));
        SwimlaneBasedDispatcher swimlaneBasedDispatcher = new SwimlaneBasedDispatcher(subscriberId, this.executorService);
        if (this.subscriberIds.contains(subscriberId)) {
            throw new RuntimeException("Duplicate subscriptionId " + subscriberId);
        }
        this.subscriberIds.add(subscriberId);
        SubscriberOptions subscriberOptions = new SubscriberOptions(a.durability(), a.readFrom(), a.progressNotifications());
        try {
            this.aggregateStore.subscribe(subscriberId, aggregatesAndEvents, subscriberOptions, de -> swimlaneBasedDispatcher.dispatch(de, arg_0 -> ((EventDispatcher)eventDispatcher).dispatch(arg_0))).get(20L, TimeUnit.SECONDS);
            this.subscriptionsRegistry.add(new RegisteredSubscription(subscriberId, aggregatesAndEvents, beanClass));
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            this.logger.error("registering event handler failed", (Throwable)e);
            throw new EventuateSubscriptionFailedException(subscriberId, e);
        }
        this.logger.info("registered event handler: bean: {}, name: {}, class", new Object[]{eventHandlerBean, beanName, beanClass});
    }

    private boolean isExceptionHandlerField(Field f) {
        return EventDeliveryExceptionHandler.class.isAssignableFrom(f.getType());
    }

    private Map<Class<?>, EventHandler> makeEventTypesAndHandlers(List<EventHandler> handlers) {
        return handlers.stream().collect(Collectors.toMap(EventHandler::getEventType, eh -> eh));
    }

    private Map<String, Set<String>> makeAggregatesAndEvents(List<EventHandler> handlers) {
        return handlers.stream().collect(Collectors.toMap(eh -> EventEntityUtil.toEntityTypeName(eh.getEventType()), eh -> Collections.singleton(eh.getEventType().getName()), (e1, e2) -> {
            HashSet r = new HashSet(e1);
            r.addAll(e2);
            return r;
        }));
    }
}

