/*
 * Decompiled with CFR 0.152.
 */
package io.eventuate.common.json.mapper;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdScalarSerializer;
import io.eventuate.common.id.Int128;
import java.io.IOException;
import java.lang.reflect.Type;

public class Int128Module
extends SimpleModule {
    public String getModuleName() {
        return "IdJsonModule";
    }

    public Int128Module() {
        this.addDeserializer(Int128.class, (JsonDeserializer)new IdDeserializer());
        this.addSerializer(Int128.class, (JsonSerializer)new IdSerializer());
    }

    class IdSerializer
    extends StdScalarSerializer<Int128> {
        public IdSerializer() {
            super(Int128.class);
        }

        public void serialize(Int128 value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeString(value.asString());
        }

        public JsonNode getSchema(SerializerProvider provider, Type typeHint, boolean isOptional) throws JsonMappingException {
            return this.createSchemaNode("string", true);
        }
    }

    class IdDeserializer
    extends StdScalarDeserializer<Int128> {
        public IdDeserializer() {
            super(Int128.class);
        }

        public Int128 deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            JsonToken token = jp.getCurrentToken();
            if (token == JsonToken.VALUE_STRING) {
                String str = jp.getText().trim();
                if (str.isEmpty()) {
                    return null;
                }
                return Int128.fromString((String)str);
            }
            throw ctxt.mappingException(this.getValueClass());
        }
    }
}

