/*
 * Decompiled with CFR 0.152.
 */
package io.eventuate.common.inmemorydatabase;

import io.eventuate.common.inmemorydatabase.EventuateDatabaseScriptSupplier;
import io.eventuate.common.jdbc.EventuateJdbcStatementExecutor;
import io.eventuate.common.jdbc.EventuateTransactionTemplate;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;

public class EmbeddedDatabaseBuilder {
    private Stream<EventuateDatabaseScriptSupplier> eventuateDatabaseScriptSuppliers;
    private EventuateJdbcStatementExecutor eventuateJdbcStatementExecutor;
    private EventuateTransactionTemplate eventuateTransactionTemplate;

    public EmbeddedDatabaseBuilder(Stream<EventuateDatabaseScriptSupplier> eventuateDatabaseScriptSuppliers, EventuateJdbcStatementExecutor eventuateJdbcStatementExecutor, EventuateTransactionTemplate eventuateTransactionTemplate) {
        this.eventuateDatabaseScriptSuppliers = eventuateDatabaseScriptSuppliers;
        this.eventuateJdbcStatementExecutor = eventuateJdbcStatementExecutor;
        this.eventuateTransactionTemplate = eventuateTransactionTemplate;
    }

    public void build() {
        this.eventuateDatabaseScriptSuppliers.flatMap(s -> ((List)s.get()).stream()).forEach(script -> this.eventuateTransactionTemplate.executeInTransaction(() -> {
            Arrays.stream(this.loadScriptAsString((String)script).split(";")).forEach(x$0 -> this.eventuateJdbcStatementExecutor.update(x$0, new Object[0]));
            return null;
        }));
    }

    private String loadScriptAsString(String script) {
        String string;
        ClassLoader classLoader = this.getClass().getClassLoader();
        BufferedReader br = new BufferedReader(new InputStreamReader(classLoader.getResourceAsStream(script)));
        try {
            String s;
            StringBuilder sb = new StringBuilder();
            while ((s = br.readLine()) != null) {
                sb.append(s);
            }
            string = sb.toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    br.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        br.close();
        return string;
    }
}

