/*
 * Decompiled with CFR 0.152.
 */
package eventcenter.monitor.server.utils;

import eventcenter.monitor.server.utils.JsonRule;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JsonRuleResolver {
    private static final Pattern RG_ARRAY = Pattern.compile("\\[(\\d*)\\](\\w+)");
    private String rule;
    private JsonRule[] jsonRules;

    JsonRuleResolver() {
    }

    JsonRuleResolver(String rule) {
        if (null == rule || "".equals(rule)) {
            throw new IllegalArgumentException("rule argument can't be null");
        }
        this.rule = rule;
        this.jsonRules = this.resolve(rule);
    }

    JsonRule[] resolve(String rule) {
        String[] ruleRegex = rule.split(",");
        JsonRule[] jsonRules = new JsonRule[ruleRegex.length];
        for (int i = 0; i < ruleRegex.length; ++i) {
            jsonRules[i] = this.resolveOne(ruleRegex[i]);
        }
        return jsonRules;
    }

    JsonRule resolveOne(String rule) {
        String[] levels = rule.split("\\.");
        JsonRule root = new JsonRule();
        this.resolveLevel(root, levels[0]);
        JsonRule prev = root;
        for (int i = 1; i < levels.length; ++i) {
            JsonRule child = new JsonRule();
            prev.setEmbedded(child);
            this.resolveLevel(child, levels[i]);
            prev = child;
        }
        return root;
    }

    void resolveLevel(JsonRule rule, String level) {
        Matcher m = RG_ARRAY.matcher(level);
        if (!m.matches()) {
            rule.setField(level);
            return;
        }
        rule.setArray(true);
        String groupValue = m.group(1);
        String field = m.group(2);
        rule.setField(field);
        if (null == groupValue || "".equals(groupValue)) {
            return;
        }
        rule.setArrayIndex(Integer.parseInt(groupValue));
    }

    public String getRule() {
        return this.rule;
    }

    public JsonRule[] getJsonRules() {
        return this.jsonRules;
    }
}

