/*
 * Decompiled with CFR 0.152.
 */
package eventcenter.monitor.server.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import eventcenter.monitor.server.utils.JsonRule;
import eventcenter.monitor.server.utils.JsonRuleResolver;
import eventcenter.remote.utils.ExpiryMap;

public class JsonRuleEngine {
    private String separatorChar = " ";
    private boolean autoCache = true;
    private long cacheExpired = 0x6DDD00L;
    private static final ExpiryMap<String, JsonRuleResolver> cache = new ExpiryMap();

    public String resolve(JSON json, String rule) {
        JsonRule[] jsonRules;
        if (null == json) {
            throw new IllegalArgumentException("json argument can't be null");
        }
        if (null == rule || "".equals(rule)) {
            return "";
        }
        String _rule = rule.trim();
        StringBuilder sb = new StringBuilder();
        for (JsonRule jsonRule : jsonRules = this.findResolver(_rule).getJsonRules()) {
            this._resolve(sb, json, jsonRule);
        }
        return sb.toString();
    }

    void _resolve(StringBuilder sb, JSON json, JsonRule jsonRule) {
        if (jsonRule.isArray()) {
            if (!(json instanceof JSONArray)) {
                return;
            }
            JSONArray ja = (JSONArray)json;
            if (jsonRule.getEmbedded() == null) {
                this.appendString(sb, this.findJsonArray(ja, jsonRule.getArrayIndex(), jsonRule.getField()));
                return;
            }
            if (null != jsonRule.getArrayIndex()) {
                JSONObject jo = (JSONObject)ja.get(jsonRule.getArrayIndex().intValue());
                if (null == jo || !jo.containsKey((Object)jsonRule.getField())) {
                    return;
                }
                this._resolve(sb, (JSON)jo.get((Object)jsonRule.getField()), jsonRule.getEmbedded());
            } else {
                for (int i = 0; i < ja.size(); ++i) {
                    JSONObject jo = (JSONObject)ja.get(i);
                    if (null == jo || !jo.containsKey((Object)jsonRule.getField())) continue;
                    this._resolve(sb, (JSON)jo.get((Object)jsonRule.getField()), jsonRule.getEmbedded());
                }
            }
            return;
        }
        if (!(json instanceof JSONObject)) {
            return;
        }
        JSONObject jo = (JSONObject)json;
        if (jsonRule.getEmbedded() == null) {
            this.appendString(sb, jo.getString(jsonRule.getField()));
            return;
        }
        if (null == jo || !jo.containsKey((Object)jsonRule.getField())) {
            return;
        }
        this._resolve(sb, (JSON)jo.get((Object)jsonRule.getField()), jsonRule.getEmbedded());
    }

    String findJsonArray(JSONArray ja, Integer arrayIndex, String field) {
        if (null != arrayIndex) {
            if (ja.size() > arrayIndex) {
                JSONObject jo = ja.getJSONObject(arrayIndex.intValue());
                if (null == jo || !jo.containsKey((Object)field)) {
                    return "";
                }
                return jo.getString(field);
            }
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < ja.size(); ++i) {
            JSONObject jo = (JSONObject)ja.get(i);
            if (null == jo || !jo.containsKey((Object)field)) continue;
            this.appendString(sb, jo.getString(field));
        }
        return sb.toString();
    }

    StringBuilder appendString(StringBuilder sb, String v) {
        if (null == v || "".equals(v.trim())) {
            return sb;
        }
        if (sb.length() == 0) {
            sb.append(v);
        } else {
            sb.append(this.separatorChar).append(v);
        }
        return sb;
    }

    JsonRuleResolver findResolver(String rule) {
        if (!cache.isStart()) {
            cache.startup();
        }
        if (cache.containKey((Object)rule)) {
            return (JsonRuleResolver)cache.get((Object)rule).getValue();
        }
        JsonRuleResolver resolver = new JsonRuleResolver(rule);
        cache.put((Object)rule, this.cacheExpired, (Object)resolver);
        return resolver;
    }

    public String getSeparatorChar() {
        return this.separatorChar;
    }

    public void setSeparatorChar(String separatorChar) {
        this.separatorChar = separatorChar;
    }

    public boolean isAutoCache() {
        return this.autoCache;
    }

    public void setAutoCache(boolean autoCache) {
        this.autoCache = autoCache;
    }

    public long getCacheExpired() {
        return this.cacheExpired;
    }

    public void setCacheExpired(long cacheExpired) {
        this.cacheExpired = cacheExpired;
    }

    public static ExpiryMap<String, JsonRuleResolver> getCache() {
        return cache;
    }
}

