/*
 * Decompiled with CFR 0.152.
 */
package eventcenter.monitor.server.dao;

import com.mongodb.Block;
import com.mongodb.client.FindIterable;
import com.mongodb.client.model.Filters;
import com.mongodb.client.result.UpdateResult;
import eventcenter.monitor.NodeInfo;
import eventcenter.monitor.server.dao.MongodbCollection;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.springframework.stereotype.Repository;

@Repository
public class NodeInfoCollection
extends MongodbCollection {
    private final String collectionName = "nodeInfo";

    @Override
    public String getCollectionName() {
        return "nodeInfo";
    }

    public void save(NodeInfo nodeInfo) {
        if (nodeInfo == null) {
            throw new IllegalArgumentException("please set nodeInfo");
        }
        if (nodeInfo.getId() == null) {
            throw new IllegalArgumentException("please set nodeInfo.id arguments");
        }
        Document doc = this.toDocument(nodeInfo);
        UpdateResult result = this.getCollection().replaceOne(Filters.eq((String)"_id", (Object)nodeInfo.getId()), (Object)doc);
        if (result.getMatchedCount() == 0L) {
            this.getCollection().insertOne((Object)doc);
            this.logger.info((Object)new StringBuilder("insert a new node info:").append(doc.toJson()));
        }
    }

    public List<NodeInfo> search(String id, String group, String name, String host) {
        Document filter = new Document();
        if (this.isNotEmpty(id)) {
            filter.append("_id", (Object)id);
        }
        if (this.isNotEmpty(group)) {
            filter.append("group", (Object)group);
        }
        if (this.isNotEmpty(name)) {
            filter.append("name", (Object)name);
        }
        if (this.isNotEmpty(host)) {
            filter.append("host", (Object)host);
        }
        FindIterable<Document> results = this.find((Bson)filter);
        final ArrayList<NodeInfo> list = new ArrayList<NodeInfo>();
        results.forEach((Block)new Block<Document>(){

            public void apply(Document document) {
                list.add(NodeInfoCollection.this.toNodeInfo(document));
            }
        });
        return list;
    }

    public List<NodeInfo> search(NodeInfo nodeInfo) {
        if (null == nodeInfo) {
            nodeInfo = new NodeInfo();
        }
        return this.search(nodeInfo.getId(), nodeInfo.getGroup(), nodeInfo.getName(), nodeInfo.getHost());
    }

    public List<NodeInfo> queryByIds(List<String> ids) {
        if (null == ids || ids.size() == 0) {
            throw new IllegalArgumentException("set ids arguments");
        }
        ArrayList<Document> conditions = new ArrayList<Document>(ids.size() + 1);
        for (String id : ids) {
            conditions.add(new Document("_id", (Object)id));
        }
        FindIterable<Document> results = this.find((Bson)new Document("$or", conditions));
        final ArrayList<NodeInfo> list = new ArrayList<NodeInfo>(ids.size() + 1);
        results.forEach((Block)new Block<Document>(){

            public void apply(Document document) {
                list.add(NodeInfoCollection.this.toNodeInfo(document));
            }
        });
        return list;
    }

    @Override
    public void createIndexes() {
    }

    protected NodeInfo toNodeInfo(Document doc) {
        NodeInfo nodeInfo = new NodeInfo();
        nodeInfo.setName(doc.getString((Object)"name"));
        nodeInfo.setStart(doc.getDate((Object)"lastStart"));
        nodeInfo.setStat(doc.getInteger((Object)"stat"));
        nodeInfo.setGroup(doc.getString((Object)"group"));
        nodeInfo.setHost(doc.getString((Object)"host"));
        nodeInfo.setId(doc.getString((Object)"_id"));
        return nodeInfo;
    }

    protected Document toDocument(NodeInfo nodeInfo) {
        return new Document().append("_id", (Object)nodeInfo.getId()).append("group", (Object)nodeInfo.getGroup()).append("host", (Object)(nodeInfo.getHost() == null ? "" : nodeInfo.getHost())).append("name", (Object)(nodeInfo.getName() == null ? "" : nodeInfo.getName())).append("lastStart", (Object)nodeInfo.getStart()).append("stat", (Object)(nodeInfo.getStat() == null ? 0 : nodeInfo.getStat())).append("modified", (Object)new Date());
    }
}

