/*
 * Decompiled with CFR 0.152.
 */
package eventcenter.monitor.server.dao;

import com.mongodb.Block;
import com.mongodb.client.FindIterable;
import eventcenter.monitor.server.dao.MongodbCollection;
import eventcenter.monitor.server.model.IndexConfig;
import eventcenter.monitor.server.model.IndexConfigs;
import eventcenter.remote.utils.ExpiryMap;
import eventcenter.remote.utils.StringWildcard;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.springframework.stereotype.Repository;

@Repository
public class IndexConfigCollection
extends MongodbCollection {
    private final String collectionName = "indexConfig";
    private long cacheExpiry = 600000L;
    final Map<String, ExpiryMap.ExpiryValue<IndexConfig>> cache = Collections.synchronizedMap(new HashMap());

    @Override
    public String getCollectionName() {
        return "indexConfig";
    }

    @Override
    public void createIndexes() {
    }

    public void save(IndexConfig config) {
        if (config.getId() == null) {
            this.insert(config);
            return;
        }
        this.update(config);
    }

    public IndexConfigs search(String group, Integer pageNo, Integer pageSize) {
        return IndexConfigs.build((int)this.searchCount(group), this._search(group, pageNo, pageSize));
    }

    private List<IndexConfig> _search(String group, Integer pageNo, Integer pageSize) {
        Document filter = this.buildCondition(group);
        if (null != pageNo) {
            filter.append("pageNo", (Object)pageNo);
        }
        if (null != pageSize) {
            filter.append("pageSize", (Object)pageSize);
        }
        FindIterable<Document> find = this.find((Bson)filter);
        if (null != pageNo && null != pageSize) {
            find.skip((pageNo - 1) * pageSize);
        }
        if (null != pageSize) {
            find.limit(pageSize.intValue());
        }
        final ArrayList<IndexConfig> result = new ArrayList<IndexConfig>();
        find.forEach((Block)new Block<Document>(){

            public void apply(Document document) {
                result.add(IndexConfigCollection.this.toIndexConfig(document));
            }
        });
        return result;
    }

    private Document buildCondition(String group) {
        Document filter = new Document();
        filter.append("matched", (Object)false);
        if (this.isNotEmpty(group)) {
            filter.append("group", (Object)group);
        }
        return filter;
    }

    private long searchCount(String group) {
        Document filter = this.buildCondition(group);
        return this.getCollection().count((Bson)filter);
    }

    public IndexConfig queryByEventName(String eventName, String group) {
        IndexConfig config;
        if (this.isEmpty(eventName)) {
            throw new IllegalArgumentException("please set eventName argument");
        }
        String cacheKey = this.buildCacheKey(eventName, group);
        if (this.cache.containsKey(cacheKey)) {
            if (!this.checkExpiry(this.cache.get(cacheKey))) {
                return (IndexConfig)this.cache.get(cacheKey).getValue();
            }
            this.cache.remove(cacheKey);
        }
        if (null != (config = this._queryByEventName(eventName, group)) && this.isNotEmpty(config.getWildcardId())) {
            config = this.queryById(config.getWildcardId());
        }
        this.cache.put(cacheKey, (ExpiryMap.ExpiryValue<IndexConfig>)ExpiryMap.ExpiryValue.build((long)this.cacheExpiry, (Object)config));
        return config;
    }

    String buildCacheKey(String eventName, String group) {
        return this.isEmpty(group) ? eventName : group + "_" + eventName;
    }

    protected boolean checkExpiry(ExpiryMap.ExpiryValue<IndexConfig> config) {
        Date now = new Date();
        return now.getTime() - config.getCreated().getTime() >= this.cacheExpiry;
    }

    protected IndexConfig _queryByEventName(String eventName, String group) {
        final ArrayList result = new ArrayList(2);
        Document filter = new Document("eventName", (Object)eventName);
        if (this.isNotEmpty(group)) {
            filter.append("group", (Object)group);
        }
        this.find((Bson)filter).forEach((Block)new Block<Document>(){

            public void apply(Document document) {
                result.add(IndexConfigCollection.this.toIndexConfig(document));
            }
        });
        if (result.size() > 0) {
            return (IndexConfig)result.get(0);
        }
        List<IndexConfig> wildcardConfigs = this.queryByWildcard();
        if (wildcardConfigs.size() == 0) {
            return null;
        }
        Object matched = null;
        for (IndexConfig config : wildcardConfigs) {
            if (!this.match(eventName, config.getEventName())) continue;
            matched = config;
            break;
        }
        if (null != matched && !matched.equals(eventName)) {
            IndexConfig matchedConfig = this.createMatchedConfig(eventName, ((IndexConfig)matched).getId(), group);
            this.insert(matchedConfig);
        }
        return matched;
    }

    protected boolean match(String source, String pattern) {
        return StringWildcard.wildMatch((String)pattern, (String)source);
    }

    protected IndexConfig createMatchedConfig(String eventName, String wildcardId, String group) {
        IndexConfig config = new IndexConfig();
        config.setEventName(eventName);
        config.setMatched(true);
        config.setWildcardId(wildcardId);
        config.setGroup(group);
        return config;
    }

    protected List<IndexConfig> queryByWildcard() {
        final ArrayList<IndexConfig> result = new ArrayList<IndexConfig>();
        this.find((Bson)new Document("wildcard", (Object)true)).forEach((Block)new Block<Document>(){

            public void apply(Document document) {
                result.add(IndexConfigCollection.this.toIndexConfig(document));
            }
        });
        return result;
    }

    public IndexConfig queryById(String id) {
        FindIterable<Document> result = this.find((Bson)new Document("_id", (Object)id));
        final ArrayList configs = new ArrayList(2);
        result.forEach((Block)new Block<Document>(){

            public void apply(Document document) {
                configs.add(IndexConfigCollection.this.toIndexConfig(document));
            }
        });
        return configs.size() == 0 ? null : (IndexConfig)configs.get(0);
    }

    public long deleteById(String id) {
        if (this.isEmpty(id)) {
            throw new IllegalArgumentException("please set id argument");
        }
        IndexConfig origin = this.queryById(id);
        if (origin == null) {
            throw new IllegalArgumentException("can't find data with id:" + id);
        }
        long deleteCount = 0L;
        deleteCount = this.deleteOne((Bson)new Document("_id", (Object)id)).getDeletedCount();
        if (origin.isWildcard()) {
            deleteCount += this.deleteByWildcardId(id);
        }
        this.cache.clear();
        return deleteCount;
    }

    protected long deleteByWildcardId(String id) {
        return this.deleteMany((Bson)new Document("wildcardId", (Object)id)).getDeletedCount();
    }

    private void insert(IndexConfig config) {
        if (this.isEmpty(config.getEventName())) {
            throw new IllegalArgumentException("please set config.eventName arguments");
        }
        if (!config.isMatched()) {
            if (this.isEmpty(config.getArgsIndexes()) && this.isEmpty(config.getResultIndexes())) {
                throw new IllegalArgumentException("please set config.argsIndexes or config.resultIndexes arguments");
            }
        } else if (this.isEmpty(config.getWildcardId())) {
            throw new IllegalArgumentException("please set config.wildcardId if config is matched");
        }
        config.setId(UUID.randomUUID().toString());
        config.setCreated(new Date());
        config.setModified(new Date());
        config.setWildcard(this.isWildcard(config.getEventName()));
        this.insertOne(this.toDocument(config));
    }

    boolean isWildcard(String eventName) {
        return eventName.contains("*");
    }

    void update(IndexConfig config) {
        IndexConfig origin = this.queryById(config.getId());
        if (origin.isWildcard() && this.isNotEmpty(config.getEventName())) {
            boolean isWildcard = this.isWildcard(config.getEventName());
            if (!isWildcard || !origin.getEventName().equals(config.getEventName())) {
                this.deleteByWildcardId(origin.getId());
            }
            config.setWildcard(isWildcard);
        } else {
            config.setWildcard(origin.isWildcard());
        }
        this.cache.clear();
        this.updateOne((Bson)new Document("_id", (Object)config.getId()), (Bson)this.toDocument(config));
    }

    private Document toDocument(IndexConfig config) {
        Document doc = new Document();
        if (this.isNotEmpty(config.getId())) {
            doc.append("_id", (Object)config.getId());
        }
        if (this.isNotEmpty(config.getEventName())) {
            doc.append("eventName", (Object)config.getEventName());
        }
        if (this.isNotEmpty(config.getArgsIndexes())) {
            doc.append("argsIndexes", (Object)config.getArgsIndexes());
        }
        if (this.isNotEmpty(config.getResultIndexes())) {
            doc.append("resultIndexes", (Object)config.getResultIndexes());
        }
        if (config.getCreated() != null) {
            doc.append("created", (Object)config.getCreated());
        }
        if (config.getModified() != null) {
            doc.append("modified", (Object)config.getModified());
        }
        if (this.isNotEmpty(config.getGroup())) {
            doc.append("group", (Object)config.getGroup());
        }
        doc.append("matched", (Object)config.isMatched());
        doc.append("wildcard", (Object)config.isWildcard());
        if (this.isNotEmpty(config.getWildcardId())) {
            doc.append("wildcardId", (Object)config.getWildcardId());
        }
        return doc;
    }

    private IndexConfig toIndexConfig(Document doc) {
        IndexConfig config = new IndexConfig();
        config.setId(doc.getString((Object)"_id"));
        config.setModified(doc.getDate((Object)"modified"));
        config.setCreated(doc.getDate((Object)"created"));
        config.setArgsIndexes(doc.getString((Object)"argsIndexes"));
        config.setResultIndexes(doc.getString((Object)"resultIndexes"));
        config.setEventName(doc.getString((Object)"eventName"));
        config.setWildcard(doc.getBoolean((Object)"wildcard"));
        config.setMatched(doc.getBoolean((Object)"matched"));
        config.setWildcardId(doc.getString((Object)"wildcardId"));
        config.setGroup(doc.getString((Object)"group"));
        return config;
    }

    public long getCacheExpiry() {
        return this.cacheExpiry;
    }

    public void setCacheExpiry(long cacheExpiry) {
        this.cacheExpiry = cacheExpiry;
    }
}

