/*
 * Decompiled with CFR 0.152.
 */
package eventcenter.monitor.server.controller;

import com.alibaba.fastjson.JSONObject;
import eventcenter.monitor.NodeInfo;
import eventcenter.monitor.server.dao.EventInfoCollection;
import java.util.Date;
import javax.annotation.Resource;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@Scope(value="prototype")
@RequestMapping(value={"/event"})
public class EventInfoController {
    @Resource
    EventInfoCollection eventInfoCollection;

    public EventInfoCollection getEventInfoCollection() {
        return this.eventInfoCollection;
    }

    public void setEventInfoCollection(EventInfoCollection eventInfoCollection) {
        this.eventInfoCollection = eventInfoCollection;
    }

    @RequestMapping(value={"/list"}, method={RequestMethod.GET})
    @ResponseBody
    public Object list(String eventId, String eventName, Date start, Date end, String listenerClass, String mdcValue, String content, Integer pageNo, Integer pageSize, String nodeId, String nodeName, String nodeGroup) {
        NodeInfo nodeInfo = null;
        if (!(StringUtils.isEmpty((Object)nodeId) && StringUtils.isEmpty((Object)nodeName) && StringUtils.isEmpty((Object)nodeGroup))) {
            nodeInfo = new NodeInfo();
            nodeInfo.setId(nodeId);
            nodeInfo.setName(nodeName);
            nodeInfo.setGroup(nodeGroup);
        }
        return this.eventInfoCollection.search(eventId, eventName, start, end, listenerClass, mdcValue, content, pageNo, pageSize, nodeInfo);
    }

    @RequestMapping(value={"/detail"}, method={RequestMethod.GET})
    @ResponseBody
    public Object detail(String id) {
        return this.eventInfoCollection.queryById(id);
    }

    @RequestMapping(value={"/housekeeping"}, method={RequestMethod.POST})
    @ResponseBody
    public Object houseKeeping(Integer keepdays) {
        if (null == keepdays) {
            keepdays = 7;
        }
        this.eventInfoCollection.houseKeeping(keepdays);
        JSONObject jo = new JSONObject();
        jo.put("status", (Object)"success");
        return jo;
    }
}

