/*
 * Decompiled with CFR 0.152.
 */
package eventcenter.monitor.server.controller;

import com.alibaba.fastjson.JSONObject;
import eventcenter.monitor.server.dao.EventContainerTraceCollection;
import java.util.Date;
import javax.annotation.Resource;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@Scope(value="prototype")
@RequestMapping(value={"/trace"})
public class ContainerTraceController {
    @Resource
    EventContainerTraceCollection containerTraceCollection;

    public EventContainerTraceCollection getContainerTraceCollection() {
        return this.containerTraceCollection;
    }

    public void setContainerTraceCollection(EventContainerTraceCollection containerTraceCollection) {
        this.containerTraceCollection = containerTraceCollection;
    }

    @RequestMapping(value={"/list"}, method={RequestMethod.GET})
    @ResponseBody
    public Object list(String nodeId, Integer pageNo, Integer pageSize, Long start, Long end) {
        return this.containerTraceCollection.searchWithPage(nodeId, pageNo, pageSize, start != null ? new Date(start) : null, end != null ? new Date(end) : null);
    }

    @RequestMapping(value={"/housekeeping"}, method={RequestMethod.POST})
    @ResponseBody
    public Object houseKeeping(Integer keepdays) {
        if (null == keepdays) {
            keepdays = 7;
        }
        this.containerTraceCollection.houseKeeping(keepdays);
        JSONObject jo = new JSONObject();
        jo.put("status", (Object)"success");
        return jo;
    }
}

