/*
 * Decompiled with CFR 0.152.
 */
package eventcenter.monitor.server;

import eventcenter.monitor.InfoForward;
import eventcenter.monitor.MonitorEventInfo;
import eventcenter.monitor.NodeInfo;
import eventcenter.monitor.server.dao.EventContainerTraceCollection;
import eventcenter.monitor.server.dao.EventInfoCollection;
import eventcenter.monitor.server.dao.NodeInfoCollection;
import eventcenter.monitor.server.model.ContainerTrace;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class InfoForwardServer
implements InfoForward {
    @Resource
    private EventInfoCollection eventInfoCollection;
    @Resource
    private NodeInfoCollection nodeInfoCollection;
    @Resource
    private EventContainerTraceCollection containerTraceCollection;
    protected final Logger logger = Logger.getLogger(this.getClass());
    protected final Logger traceLogger = Logger.getLogger((String)"node-info-log");

    public EventInfoCollection getEventInfoCollection() {
        return this.eventInfoCollection;
    }

    public void setEventInfoCollection(EventInfoCollection eventInfoCollection) {
        this.eventInfoCollection = eventInfoCollection;
    }

    public NodeInfoCollection getNodeInfoCollection() {
        return this.nodeInfoCollection;
    }

    public void setNodeInfoCollection(NodeInfoCollection nodeInfoCollection) {
        this.nodeInfoCollection = nodeInfoCollection;
    }

    public void forwardNodeInfo(NodeInfo info) {
        try {
            this.nodeInfoCollection.save(info);
        }
        catch (Exception e) {
            this.logger.error((Object)new StringBuilder("save nodeInfo error:").append(e.getMessage()), (Throwable)e);
        }
        try {
            if (info.getQueueSize() != null) {
                this.containerTraceCollection.insert(this.toContainerTrace(info));
            }
        }
        catch (Exception e) {
            this.logger.error((Object)new StringBuilder("save containerTrace error:").append(e.getMessage()), (Throwable)e);
        }
    }

    ContainerTrace toContainerTrace(NodeInfo info) {
        ContainerTrace trace = new ContainerTrace();
        trace.setNodeId(info.getId());
        trace.setCountOfQueueBuffer(info.getCountOfQueueBuffer());
        trace.setCountOfLiveThread(info.getCountOfLiveThread());
        trace.setQueueSize(info.getQueueSize());
        trace.setCreated(new Date());
        return trace;
    }

    public void forwardEventInfo(List<MonitorEventInfo> infos) {
        try {
            this.eventInfoCollection.insert(infos);
            if (this.traceLogger.isTraceEnabled()) {
                for (MonitorEventInfo info : infos) {
                    this.traceLogger.trace((Object)info);
                }
            }
        }
        catch (Exception e) {
            this.logger.error((Object)new StringBuilder("save eventInfos error:").append(e.getMessage()), (Throwable)e);
        }
    }
}

