/*
 * Decompiled with CFR 0.152.
 */
package eventcenter.monitor.mysql.dao;

import eventcenter.api.appcache.IdentifyContext;
import eventcenter.monitor.mysql.dao.BaseDAO;
import eventcenter.monitor.mysql.dao.IJdbcTemplateCallback;
import eventcenter.remote.SubscriberGroup;
import eventcenter.remote.utils.StringHelper;
import java.util.Date;
import javax.sql.DataSource;
import org.springframework.jdbc.core.JdbcTemplate;

public class SubscriberInfoDAO
extends BaseDAO {
    static final String TABLE_NAME = "sub_info";
    private String nodeId;
    static final String SQL_CREATE_TABLE = "CREATE TABLE `sub_info` (\n\t`node_id` VARCHAR(128) NOT NULL,\n\t`group` VARCHAR(128) NOT NULL,\n\t`sub_event` VARCHAR(2048) NOT NULL,\n\t`created` datetime NOT NULL,\n\tPRIMARY KEY (`node_id`, `group`)) ENGINE=InnoDB  DEFAULT CHARSET=utf8;";
    static final String SQL_INSERT = "insert into `sub_info` (`node_id`, `group`, `sub_event`, `created`) values (?, ?, ?, ?) on duplicate key update `sub_event` = ?";

    public SubscriberInfoDAO() {
    }

    public SubscriberInfoDAO(DataSource dataSource) {
        super(dataSource);
    }

    @Override
    protected String getBuildTableSql(String tableName) {
        return SQL_CREATE_TABLE;
    }

    @Override
    protected String getTableName() {
        return TABLE_NAME;
    }

    @Override
    protected String buildTableName(String tableNamePrefix) {
        return tableNamePrefix;
    }

    private String getNodeId() {
        if (StringHelper.isNotEmpty((String)this.nodeId)) {
            return this.nodeId;
        }
        try {
            this.nodeId = IdentifyContext.getId();
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage());
            this.nodeId = "";
        }
        return this.nodeId;
    }

    public void save(SubscriberGroup subscriberGroup) {
        super.save(new IJdbcTemplateCallback(){

            @Override
            public void handle(JdbcTemplate jdbcTemplate, Object ... args) {
                SubscriberGroup group = (SubscriberGroup)args[0];
                jdbcTemplate.update(SubscriberInfoDAO.SQL_INSERT, new Object[]{SubscriberInfoDAO.this.getNodeId(), group.getGroupName() == null ? "default" : group.getGroupName(), group.getRemoteEvents(), new Date(), group.getRemoteEvents()});
            }
        }, subscriberGroup);
    }
}

