/*
 * Decompiled with CFR 0.152.
 */
package eventcenter.monitor.mysql;

import eventcenter.api.CommonEventSource;
import eventcenter.api.EventFireFilter;
import eventcenter.api.EventInfo;
import eventcenter.api.appcache.IdentifyContext;
import eventcenter.leveldb.LevelDBPersistenceAdapter;
import eventcenter.leveldb.LevelDBQueue;
import eventcenter.leveldb.QueueMiddleComponent;
import eventcenter.monitor.mysql.dao.FiredEventDAO;
import eventcenter.remote.utils.StringHelper;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.sql.DataSource;
import org.apache.log4j.Logger;

public class MySqlEventFireFilter
implements EventFireFilter {
    private final Logger logger = Logger.getLogger(this.getClass());
    DataSource controlMonitorDataSource;
    FiredEventDAO firedEventDAO;
    private String nodeId;
    private LevelDBPersistenceAdapter adapter;
    private QueueMiddleComponent queueMiddle;
    private LevelDBQueue queue;
    private int batchSaveNum = 10;
    private volatile boolean isOpen = false;

    @PostConstruct
    public void startUp() {
        this.adapter = new LevelDBPersistenceAdapter();
        this.queueMiddle = new QueueMiddleComponent(this.adapter);
        File dir = new File(System.getProperty("user.home") + File.separator + ".monitorleveldb");
        if (!dir.exists()) {
            dir.mkdirs();
        }
        this.adapter.setDirPath(dir);
        this.adapter.setName("mysqlEventFireFilter");
        this.queue = new LevelDBQueue(this.queueMiddle);
        try {
            this.queue.open();
            this.isOpen = true;
        }
        catch (IOException e) {
            this.logger.error((Object)("startup mySqlEventFireFilter failure:" + e.getMessage()), (Throwable)e);
        }
        new BatchSaveEventFireInfoToMySqlThread().start();
    }

    @PreDestroy
    public void shutdown() throws Exception {
        if (null != this.queue) {
            this.queue.close();
        }
    }

    public void onFired(Object target, EventInfo eventInfo, Object result) {
        CommonEventSource commonEventSource = new CommonEventSource(target, eventInfo.getId(), eventInfo.getName(), null, null, eventInfo.getMdcValue());
        commonEventSource.setSourceInfo((Object)eventInfo);
        commonEventSource.setSourceClassName(null != target ? target.getClass().getName() : "null");
        this.queue.offer(commonEventSource);
    }

    private String getNodeId() {
        if (StringHelper.isNotEmpty((String)this.nodeId)) {
            return this.nodeId;
        }
        try {
            this.nodeId = IdentifyContext.getId();
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage());
            this.nodeId = "";
        }
        return this.nodeId;
    }

    FiredEventDAO getFiredEventDAO() {
        if (null != this.firedEventDAO) {
            return this.firedEventDAO;
        }
        if (null == this.controlMonitorDataSource) {
            throw new IllegalArgumentException("please set parameter of controlMonitorDataSource");
        }
        this.firedEventDAO = new FiredEventDAO(this.controlMonitorDataSource);
        return this.firedEventDAO;
    }

    public DataSource getControlMonitorDataSource() {
        return this.controlMonitorDataSource;
    }

    public void setControlMonitorDataSource(DataSource controlMonitorDataSource) {
        this.controlMonitorDataSource = controlMonitorDataSource;
    }

    public int getBatchSaveNum() {
        return this.batchSaveNum;
    }

    public void setBatchSaveNum(int batchSaveNum) {
        this.batchSaveNum = batchSaveNum;
    }

    private class BatchSaveEventFireInfoToMySqlThread
    extends Thread {
        public BatchSaveEventFireInfoToMySqlThread() {
            super("batchsave-eventfireinfo-to-mysql-thread");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ArrayList<CommonEventSource> list = new ArrayList<CommonEventSource>(MySqlEventFireFilter.this.batchSaveNum);
            while (MySqlEventFireFilter.this.isOpen) {
                CommonEventSource eventSourceBase = MySqlEventFireFilter.this.queue.transfer(1000L);
                String nid = MySqlEventFireFilter.this.getNodeId();
                if (null != nid && null != eventSourceBase) {
                    list.add(eventSourceBase);
                }
                if (MySqlEventFireFilter.this.batchSaveNum != list.size()) continue;
                try {
                    ArrayList<FiredEventDAO.FiredEventSaveDTO> dtos = new ArrayList<FiredEventDAO.FiredEventSaveDTO>(MySqlEventFireFilter.this.batchSaveNum);
                    for (CommonEventSource sourceBase : list) {
                        FiredEventDAO.FiredEventSaveDTO dto = new FiredEventDAO.FiredEventSaveDTO();
                        dto.setSourceClassName(sourceBase.getSourceClassName());
                        dto.setEventInfo((EventInfo)sourceBase.getSourceInfo());
                        dto.setTimestamp(sourceBase.getTimestamp());
                        dtos.add(dto);
                    }
                    MySqlEventFireFilter.this.getFiredEventDAO().batchSave(nid, dtos);
                }
                catch (Exception e) {
                    MySqlEventFireFilter.this.logger.error((Object)e.getMessage(), (Throwable)e);
                }
                finally {
                    list.clear();
                }
            }
        }
    }
}

