/*
 * Decompiled with CFR 0.152.
 */
package eventcenter.monitor.mysql;

import com.alibaba.fastjson.JSONObject;
import eventcenter.monitor.AbstractControlMonitor;
import eventcenter.monitor.InfoForward;
import eventcenter.monitor.InfoStorage;
import eventcenter.monitor.MonitorEventInfo;
import eventcenter.monitor.NodeInfo;
import eventcenter.monitor.mysql.MysqlInfoStorage;
import eventcenter.monitor.mysql.dao.ConsumedEventDAO;
import eventcenter.monitor.mysql.dao.NodeInfoDAO;
import eventcenter.monitor.mysql.dao.ReceivedEventDAO;
import java.util.List;
import javax.sql.DataSource;

public class MySqlControlMonitor
extends AbstractControlMonitor {
    DataSource controlMonitorDataSource;
    NodeInfoDAO nodeInfoDAO;
    ConsumedEventDAO consumedEventDAO;
    ReceivedEventDAO receivedEventDAO;

    public void startup() {
        if (this.open || delayInitLock.isLock()) {
            return;
        }
        if (null == this.controlMonitorDataSource) {
            throw new IllegalArgumentException("please set parameter of controlMonitorDataSource");
        }
        this.nodeInfoDAO = new NodeInfoDAO(this.controlMonitorDataSource);
        this.consumedEventDAO = new ConsumedEventDAO(this.controlMonitorDataSource);
        this.receivedEventDAO = new ReceivedEventDAO(this.controlMonitorDataSource);
        this.init();
        this.infoForward = new LogInfoForward();
        this.openHeartBeat();
    }

    protected void init() {
        super.init();
        try {
            this.nodeInfoDAO.init();
            this.nodeInfoDAO.save(this.nodeInfo);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    protected InfoStorage loadInfoStorage() {
        MysqlInfoStorage storage = new MysqlInfoStorage();
        storage.setConsumedEventDAO(this.consumedEventDAO);
        storage.setReceivedEventDAO(this.receivedEventDAO);
        return storage;
    }

    public DataSource getControlMonitorDataSource() {
        return this.controlMonitorDataSource;
    }

    public void setControlMonitorDataSource(DataSource controlMonitorDataSource) {
        this.controlMonitorDataSource = controlMonitorDataSource;
    }

    class LogInfoForward
    implements InfoForward {
        LogInfoForward() {
        }

        public void forwardNodeInfo(NodeInfo info) {
            MySqlControlMonitor.this.logger.info(JSONObject.toJSON((Object)info));
        }

        public void forwardEventInfo(List<MonitorEventInfo> infos) {
        }
    }
}

