/*
 * Decompiled with CFR 0.152.
 */
package eventcenter.monitor.mysql.dao;

import eventcenter.monitor.mysql.dao.IJdbcTemplateCallback;
import eventcenter.remote.utils.StringHelper;
import javax.annotation.PostConstruct;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.springframework.jdbc.BadSqlGrammarException;
import org.springframework.jdbc.core.JdbcTemplate;

public abstract class BaseDAO {
    protected static final String SQL_SHOW_TABLES = "SHOW TABLES LIKE ?";
    protected static final String TABLE_NAME_SEPARATOR = "_";
    private DataSource dataSource;
    private JdbcTemplate jdbcTemplate;
    protected final Logger logger = Logger.getLogger(this.getClass());
    protected volatile boolean isInit = false;

    public BaseDAO() {
    }

    public BaseDAO(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @PostConstruct
    public void init() {
        if (this.isInit) {
            return;
        }
        if (StringHelper.isEmpty((String)this.getTableName())) {
            throw new IllegalArgumentException("please set parameter of tableName");
        }
        if (null == this.dataSource) {
            throw new IllegalArgumentException("please set parameter of dataSource");
        }
        try {
            if (!this.checkTableExists(this.getTableName())) {
                this.createTable(this.getTableName());
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
        this.isInit = true;
    }

    protected boolean checkTableExists(String tableName) {
        if (StringHelper.isEmpty((String)tableName)) {
            throw new IllegalArgumentException("please set tableName");
        }
        String tn = this.buildTableName(tableName);
        String result = (String)this.getJdbcTemplate().queryForObject(SQL_SHOW_TABLES, String.class, new Object[]{tn});
        return StringHelper.equals((String)tn, (String)result);
    }

    protected void createTable(String tableName) {
        String sql = this.getBuildTableSql(tableName);
        long start = System.currentTimeMillis();
        this.getJdbcTemplate().execute(sql);
        this.logger.info((Object)("create table:" + sql + " success, took:" + (System.currentTimeMillis() - start) + " ms."));
    }

    protected abstract String getBuildTableSql(String var1);

    protected abstract String getTableName();

    protected void save(IJdbcTemplateCallback callback, Object ... args) {
        this.save0(0, callback, args);
    }

    private boolean save0(int retry, IJdbcTemplateCallback callback, Object ... args) {
        if (retry > 2) {
            return false;
        }
        try {
            callback.handle(this.getJdbcTemplate(), args);
            return true;
        }
        catch (BadSqlGrammarException e) {
            if (e.getSQLException() == null || !e.getSQLException().getMessage().contains("doesn't exist")) {
                throw e;
            }
            this.createTable0(++retry, callback, args);
            return this.save0(retry, callback, args);
        }
    }

    private void createTable0(int retry, IJdbcTemplateCallback callback, Object ... args) {
        block3: {
            try {
                this.createTable(this.getTableName());
            }
            catch (BadSqlGrammarException e) {
                if (e.getSQLException() == null || !e.getSQLException().getMessage().contains("already exists")) {
                    throw e;
                }
                if (this.save0(++retry, callback, args)) break block3;
                throw e;
            }
        }
    }

    protected abstract String buildTableName(String var1);

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JdbcTemplate getJdbcTemplate() {
        if (null == this.dataSource) {
            throw new IllegalArgumentException("please set parameter of dataSource");
        }
        if (null == this.jdbcTemplate) {
            BaseDAO baseDAO = this;
            synchronized (baseDAO) {
                if (null != this.jdbcTemplate) {
                    return this.jdbcTemplate;
                }
                this.jdbcTemplate = new JdbcTemplate(this.dataSource);
            }
        }
        return this.jdbcTemplate;
    }
}

