/*
 * Decompiled with CFR 0.152.
 */
package eventcenter.monitor.mysql;

import eventcenter.monitor.mysql.dao.SubscriberInfoDAO;
import eventcenter.remote.SubscriberGroup;
import eventcenter.remote.subscriber.SubscriberStartupFilter;
import java.util.Collection;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.log4j.Logger;

public class MySqlSubscriberStartupFilter
implements SubscriberStartupFilter {
    DataSource controlMonitorDataSource;
    SubscriberInfoDAO subscriberInfoDAO;
    final Logger logger = Logger.getLogger(this.getClass());

    public void onStartup(Map<String, SubscriberGroup> subscriberGroups) {
        if (null == subscriberGroups) {
            return;
        }
        try {
            Collection<SubscriberGroup> groups = subscriberGroups.values();
            for (SubscriberGroup group : groups) {
                this.getSubscriberInfoDAO().save(group);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    SubscriberInfoDAO getSubscriberInfoDAO() {
        if (null != this.subscriberInfoDAO) {
            return this.subscriberInfoDAO;
        }
        this.subscriberInfoDAO = new SubscriberInfoDAO(this.controlMonitorDataSource);
        return this.subscriberInfoDAO;
    }

    public DataSource getControlMonitorDataSource() {
        return this.controlMonitorDataSource;
    }

    public void setControlMonitorDataSource(DataSource controlMonitorDataSource) {
        this.controlMonitorDataSource = controlMonitorDataSource;
    }
}

