/*
 * Decompiled with CFR 0.152.
 */
package eventcenter.monitor.elasticsearch;

import eventcenter.monitor.InfoForward;
import eventcenter.monitor.MonitorEventInfo;
import eventcenter.monitor.NodeInfo;
import eventcenter.monitor.elasticsearch.ElasticSearchClientFactory;
import io.searchbox.action.Action;
import io.searchbox.action.BulkableAction;
import io.searchbox.client.JestClient;
import io.searchbox.client.JestResult;
import io.searchbox.core.Bulk;
import io.searchbox.core.BulkResult;
import io.searchbox.core.Index;
import io.searchbox.indices.CreateIndex;
import io.searchbox.indices.IndicesExists;
import io.searchbox.indices.mapping.PutMapping;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.log4j.Logger;

public class ElasticSearchInfoForward
implements InfoForward {
    public static final String INDEX_NODE = "ec-node";
    public static final String INDEX_EVENT = "ec-event";
    public static final String INDEX_SEND = "ec-send";
    public static final String INDEX_RECEIVED = "ec-received";
    public static final Integer MINMUM_PUSH_NODE_INFO_INTERVAL = 30;
    protected static final String MAPPING_NODE_STRING = "{\n        \"node\" : {\n            \"properties\" : {\n                \"start\" :{\"type\" : \"date\", \"format\":\"date_time\"},\n                \"timestamp\" :{\"type\" : \"date\", \"format\":\"date_time\"},\n                \"id\" : {\"type\" : \"string\", \"index\" : \"not_analyzed\"},\n                \"group\" : {\"type\" : \"string\", \"index\" : \"not_analyzed\"},\n                \"name\" : {\"type\" : \"string\", \"index\" : \"not_analyzed\"},\n                \"host\" : {\"type\" : \"ip\", \"index\" : \"not_analyzed\"},\n                \"stat\" : {\"type\" : \"long\"},\n                \"queueSize\" : {\"type\" : \"long\"},\n                \"countOfLiveThread\" : {\"type\" : \"integer\"},\n                \"countOfQueueBuffer\" : {\"type\" : \"long\"}\n            }\n        }\n    }";
    protected static final String MAPPING_EVENT_STRING = "{\n    \t\"event\" : {\n            \"properties\" : {\n                \"created\" :{\"type\" : \"date\", \"format\":\"date_time\"},\n                \"start\" :{\"type\" : \"date\", \"format\":\"date_time\"},\n                \"consumed\" :{\"type\" : \"date\", \"format\":\"date_time\"},\n                \"nodeId\" : {\"type\" : \"string\", \"index\" : \"not_analyzed\"},\n                \"nodeGroup\" : {\"type\" : \"string\", \"index\" : \"not_analyzed\"},\n                \"nodeHost\" : {\"type\" : \"ip\", \"index\" : \"not_analyzed\"},\n                \"fromNodeId\" : {\"type\" : \"string\", \"index\" : \"not_analyzed\"},\n                \"exception\" : {\"type\" : \"string\", \"index\" : \"not_analyzed\"},\n                \"listenerClazz\" : {\"type\" : \"string\", \"index\" : \"not_analyzed\"},\n                \"exception\" : {\"type\" : \"string\", \"index\" : \"not_analyzed\"},\n                \"eventArgs\" : {\"type\" : \"string\", \"index\" : \"not_analyzed\"},\n                \"eventResult\" : {\"type\" : \"string\", \"index\" : \"not_analyzed\"},\n                \"eventId\" : {\"type\" : \"string\", \"index\" : \"not_analyzed\"},\n                \"eventName\" : {\"type\" : \"string\", \"index\" : \"not_analyzed\"},\n                \"mdcValue\" : {\"type\" : \"string\", \"index\" : \"not_analyzed\"},\n                \"took\" : {\"type\" : \"long\"},\n                \"delay\" : {\"type\" : \"long\"}\n            }\n        }\n    }";
    protected static final String MAPPING_SEND_STRING = "{\n    \t\"send\" : {\n            \"properties\" : {\n                \"created\" :{\"type\" : \"date\", \"format\":\"date_time\"},\n                \"start\" :{\"type\" : \"date\", \"format\":\"date_time\"},\n                \"nodeId\" : {\"type\" : \"string\", \"index\" : \"not_analyzed\"},\n                \"nodeGroup\" : {\"type\" : \"string\", \"index\" : \"not_analyzed\"},\n                \"nodeHost\" : {\"type\" : \"ip\", \"index\" : \"not_analyzed\"},\n                \"sendHost\" : {\"type\" : \"string\", \"index\" : \"not_analyzed\"},\n                \"exception\" : {\"type\" : \"string\", \"index\" : \"not_analyzed\"},\n                \"eventId\" : {\"type\" : \"string\", \"index\" : \"not_analyzed\"},\n                \"eventName\" : {\"type\" : \"string\", \"index\" : \"not_analyzed\"},\n                \"mdcValue\" : {\"type\" : \"string\", \"index\" : \"not_analyzed\"},\n                \"success\" : {\"type\" : \"string\", \"index\" : \"not_analyzed\"},\n                \"took\" : {\"type\" : \"long\"}\n            }\n        }\n    }";
    protected static final String MAPPING_RECEIVED_STRING = "{\n    \t\"received\" : {\n            \"properties\" : {\n                \"created\" :{\"type\" : \"date\", \"format\":\"date_time\"},\n                \"start\" :{\"type\" : \"date\", \"format\":\"date_time\"},\n                \"nodeId\" : {\"type\" : \"string\", \"index\" : \"not_analyzed\"},\n                \"fromNodeId\" : {\"type\" : \"string\", \"index\" : \"not_analyzed\"},\n                \"nodeGroup\" : {\"type\" : \"string\", \"index\" : \"not_analyzed\"},\n                \"nodeHost\" : {\"type\" : \"ip\", \"index\" : \"not_analyzed\"},\n                \"eventId\" : {\"type\" : \"string\", \"index\" : \"not_analyzed\"},\n                \"eventName\" : {\"type\" : \"string\", \"index\" : \"not_analyzed\"},\n                \"mdcValue\" : {\"type\" : \"string\", \"index\" : \"not_analyzed\"},\n                \"delay\" : {\"type\" : \"long\"}\n            }\n        }\n    }";
    protected JestClient jestClient;
    private String elasticHost;
    private String nodeIndex = "ec-node";
    private String nodeMapping = "{\n        \"node\" : {\n            \"properties\" : {\n                \"start\" :{\"type\" : \"date\", \"format\":\"date_time\"},\n                \"timestamp\" :{\"type\" : \"date\", \"format\":\"date_time\"},\n                \"id\" : {\"type\" : \"string\", \"index\" : \"not_analyzed\"},\n                \"group\" : {\"type\" : \"string\", \"index\" : \"not_analyzed\"},\n                \"name\" : {\"type\" : \"string\", \"index\" : \"not_analyzed\"},\n                \"host\" : {\"type\" : \"ip\", \"index\" : \"not_analyzed\"},\n                \"stat\" : {\"type\" : \"long\"},\n                \"queueSize\" : {\"type\" : \"long\"},\n                \"countOfLiveThread\" : {\"type\" : \"integer\"},\n                \"countOfQueueBuffer\" : {\"type\" : \"long\"}\n            }\n        }\n    }";
    private String eventIndex = "ec-event";
    private String eventMapping = "{\n    \t\"event\" : {\n            \"properties\" : {\n                \"created\" :{\"type\" : \"date\", \"format\":\"date_time\"},\n                \"start\" :{\"type\" : \"date\", \"format\":\"date_time\"},\n                \"consumed\" :{\"type\" : \"date\", \"format\":\"date_time\"},\n                \"nodeId\" : {\"type\" : \"string\", \"index\" : \"not_analyzed\"},\n                \"nodeGroup\" : {\"type\" : \"string\", \"index\" : \"not_analyzed\"},\n                \"nodeHost\" : {\"type\" : \"ip\", \"index\" : \"not_analyzed\"},\n                \"fromNodeId\" : {\"type\" : \"string\", \"index\" : \"not_analyzed\"},\n                \"exception\" : {\"type\" : \"string\", \"index\" : \"not_analyzed\"},\n                \"listenerClazz\" : {\"type\" : \"string\", \"index\" : \"not_analyzed\"},\n                \"exception\" : {\"type\" : \"string\", \"index\" : \"not_analyzed\"},\n                \"eventArgs\" : {\"type\" : \"string\", \"index\" : \"not_analyzed\"},\n                \"eventResult\" : {\"type\" : \"string\", \"index\" : \"not_analyzed\"},\n                \"eventId\" : {\"type\" : \"string\", \"index\" : \"not_analyzed\"},\n                \"eventName\" : {\"type\" : \"string\", \"index\" : \"not_analyzed\"},\n                \"mdcValue\" : {\"type\" : \"string\", \"index\" : \"not_analyzed\"},\n                \"took\" : {\"type\" : \"long\"},\n                \"delay\" : {\"type\" : \"long\"}\n            }\n        }\n    }";
    private String sendIndex = "ec-send";
    private String sendMapping = "{\n    \t\"send\" : {\n            \"properties\" : {\n                \"created\" :{\"type\" : \"date\", \"format\":\"date_time\"},\n                \"start\" :{\"type\" : \"date\", \"format\":\"date_time\"},\n                \"nodeId\" : {\"type\" : \"string\", \"index\" : \"not_analyzed\"},\n                \"nodeGroup\" : {\"type\" : \"string\", \"index\" : \"not_analyzed\"},\n                \"nodeHost\" : {\"type\" : \"ip\", \"index\" : \"not_analyzed\"},\n                \"sendHost\" : {\"type\" : \"string\", \"index\" : \"not_analyzed\"},\n                \"exception\" : {\"type\" : \"string\", \"index\" : \"not_analyzed\"},\n                \"eventId\" : {\"type\" : \"string\", \"index\" : \"not_analyzed\"},\n                \"eventName\" : {\"type\" : \"string\", \"index\" : \"not_analyzed\"},\n                \"mdcValue\" : {\"type\" : \"string\", \"index\" : \"not_analyzed\"},\n                \"success\" : {\"type\" : \"string\", \"index\" : \"not_analyzed\"},\n                \"took\" : {\"type\" : \"long\"}\n            }\n        }\n    }";
    private String receivedIndex = "ec-received";
    private String receivedMapping = "{\n    \t\"received\" : {\n            \"properties\" : {\n                \"created\" :{\"type\" : \"date\", \"format\":\"date_time\"},\n                \"start\" :{\"type\" : \"date\", \"format\":\"date_time\"},\n                \"nodeId\" : {\"type\" : \"string\", \"index\" : \"not_analyzed\"},\n                \"fromNodeId\" : {\"type\" : \"string\", \"index\" : \"not_analyzed\"},\n                \"nodeGroup\" : {\"type\" : \"string\", \"index\" : \"not_analyzed\"},\n                \"nodeHost\" : {\"type\" : \"ip\", \"index\" : \"not_analyzed\"},\n                \"eventId\" : {\"type\" : \"string\", \"index\" : \"not_analyzed\"},\n                \"eventName\" : {\"type\" : \"string\", \"index\" : \"not_analyzed\"},\n                \"mdcValue\" : {\"type\" : \"string\", \"index\" : \"not_analyzed\"},\n                \"delay\" : {\"type\" : \"long\"}\n            }\n        }\n    }";
    private Integer connTimeout;
    private Integer readTimeout;
    private volatile boolean open;
    private Integer nodeInfoPushInterval = MINMUM_PUSH_NODE_INFO_INTERVAL;
    private Date lastPushNodeInfoTime = null;
    private List<NodeInfo> nodeInfoCache = new ArrayList<NodeInfo>();
    private final Logger logger = Logger.getLogger(this.getClass());

    @PostConstruct
    public void startup() throws IOException {
        if (this.open) {
            return;
        }
        if (StringUtils.isEmpty((CharSequence)this.elasticHost)) {
            throw new IllegalArgumentException("please set parameter of elasticHost");
        }
        ElasticSearchClientFactory factory = new ElasticSearchClientFactory();
        factory.setElasticHost(this.elasticHost);
        factory.setConnTimeout(this.connTimeout);
        factory.setReadTimeout(this.readTimeout);
        this.jestClient = factory.createClient();
        this.handleIndex(this.nodeIndex, "node", this.nodeMapping);
        this.handleIndex(this.eventIndex, "event", this.eventMapping);
        this.handleIndex(this.sendIndex, "send", this.sendMapping);
        this.handleIndex(this.receivedIndex, "received", this.receivedMapping);
        this.logger.info((Object)String.format("startup jest client[%s]success.", this.elasticHost));
    }

    @PreDestroy
    public void shutdown() {
        if (!this.open) {
            return;
        }
        this.jestClient.shutdownClient();
        this.logger.info((Object)String.format("shutdown jest client[%s]success.", this.elasticHost));
    }

    protected void handleIndex(String index, String type, String mapping) throws IOException {
        if (!this.existsIndex(index)) {
            JestResult result = this.createIndex(index);
            if (!result.isSucceeded()) {
                throw new IllegalStateException(String.format("create %s index error:%s", index, result.getErrorMessage()));
            }
            this.logger.info((Object)String.format("create elastic index[%s]success", index));
            result = this.createMapping(index, type, mapping);
            if (!result.isSucceeded()) {
                throw new IllegalStateException(String.format("mapping %s type error:%s", index, result.getErrorMessage()));
            }
            this.logger.info((Object)String.format("mapping elastic type[%s]success", type));
        }
    }

    protected boolean existsIndex(String index) throws IOException {
        return this.jestClient.execute((Action)new IndicesExists.Builder(index).build()).isSucceeded();
    }

    protected JestResult createIndex(String index) throws IOException {
        return this.jestClient.execute((Action)new CreateIndex.Builder(index).build());
    }

    protected JestResult createMapping(String index, String type, String value) throws IOException {
        PutMapping putMapping = new PutMapping.Builder(index, type, (Object)value).build();
        return this.jestClient.execute((Action)putMapping);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forwardNodeInfo(NodeInfo info) {
        info.setTimestamp(new Date());
        if (this.lastPushNodeInfoTime == null) {
            this.lastPushNodeInfoTime = new Date();
        }
        if (new Date().before(DateUtils.addSeconds((Date)this.lastPushNodeInfoTime, (int)this.nodeInfoPushInterval))) {
            try {
                this.nodeInfoCache.add(info.clone());
            }
            catch (CloneNotSupportedException e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
            }
            return;
        }
        this.lastPushNodeInfoTime = new Date();
        if (this.nodeInfoCache.size() == 0) {
            return;
        }
        Bulk.Builder bulkBuilder = new Bulk.Builder();
        for (NodeInfo nodeInfo : this.nodeInfoCache) {
            Index index = ((Index.Builder)((Index.Builder)new Index.Builder((Object)nodeInfo).index(this.nodeIndex)).type("node")).build();
            bulkBuilder.addAction((BulkableAction)index);
        }
        try {
            BulkResult result = (BulkResult)this.jestClient.execute((Action)bulkBuilder.build());
            if (!result.isSucceeded()) {
                this.logger.error((Object)("put node index data error:" + result.getJsonString()));
            }
        }
        catch (Throwable e) {
            this.logger.error((Object)("put node index data error:" + e.getMessage()));
        }
        finally {
            this.nodeInfoCache.clear();
        }
    }

    public void forwardEventInfo(List<MonitorEventInfo> infos) {
        Bulk.Builder bulkBuilder = new Bulk.Builder();
        for (MonitorEventInfo info : infos) {
            Index index = null;
            if (info.getType() == null || info.getType().intValue() == MonitorEventInfo.TYPE_CONSUMED.intValue()) {
                index = ((Index.Builder)((Index.Builder)new Index.Builder((Object)info).index(this.eventIndex)).type("event")).build();
            } else if (info.getType().intValue() == MonitorEventInfo.TYPE_SEND.intValue()) {
                index = ((Index.Builder)((Index.Builder)new Index.Builder((Object)info).index(this.sendIndex)).type("send")).build();
            } else if (info.getType().intValue() == MonitorEventInfo.TYPE_RECEIVED.intValue()) {
                index = ((Index.Builder)((Index.Builder)new Index.Builder((Object)info).index(this.receivedIndex)).type("received")).build();
            }
            if (null == index) continue;
            bulkBuilder.addAction((BulkableAction)index);
        }
        try {
            BulkResult result = (BulkResult)this.jestClient.execute((Action)bulkBuilder.build());
            if (!result.isSucceeded()) {
                String errorInfo = result.getJsonString();
                if (errorInfo.contains("\"status\":429")) {
                    throw new RuntimeException("access elastic search error:status:429, it would retry");
                }
                this.logger.error((Object)("put event index data error:" + errorInfo));
            }
        }
        catch (Throwable e) {
            this.logger.error((Object)("put event index data error:" + e.getMessage()));
        }
    }

    public String getElasticHost() {
        return this.elasticHost;
    }

    public void setElasticHost(String elasticHost) {
        this.elasticHost = elasticHost;
    }

    public Integer getConnTimeout() {
        return this.connTimeout;
    }

    public void setConnTimeout(Integer connTimeout) {
        this.connTimeout = connTimeout;
    }

    public Integer getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(Integer readTimeout) {
        this.readTimeout = readTimeout;
    }

    public String getNodeIndex() {
        return this.nodeIndex;
    }

    public void setNodeIndex(String nodeIndex) {
        this.nodeIndex = nodeIndex;
    }

    public String getEventIndex() {
        return this.eventIndex;
    }

    public void setEventIndex(String eventIndex) {
        this.eventIndex = eventIndex;
    }

    public String getNodeMapping() {
        return this.nodeMapping;
    }

    public void setNodeMapping(String nodeMapping) {
        this.nodeMapping = nodeMapping;
    }

    public String getEventMapping() {
        return this.eventMapping;
    }

    public void setEventMapping(String eventMapping) {
        this.eventMapping = eventMapping;
    }

    public Integer getNodeInfoPushInterval() {
        return this.nodeInfoPushInterval;
    }

    public String getSendIndex() {
        return this.sendIndex;
    }

    public void setSendIndex(String sendIndex) {
        this.sendIndex = sendIndex;
    }

    public String getSendMapping() {
        return this.sendMapping;
    }

    public void setSendMapping(String sendMapping) {
        this.sendMapping = sendMapping;
    }

    public String getReceivedIndex() {
        return this.receivedIndex;
    }

    public void setReceivedIndex(String receivedIndex) {
        this.receivedIndex = receivedIndex;
    }

    public String getReceivedMapping() {
        return this.receivedMapping;
    }

    public void setReceivedMapping(String receivedMapping) {
        this.receivedMapping = receivedMapping;
    }

    public void setNodeInfoPushInterval(Integer nodeInfoPushInterval) {
        if (null == nodeInfoPushInterval) {
            throw new IllegalArgumentException("parameter of nodeInfoPushInterval has to be set");
        }
        if (nodeInfoPushInterval < MINMUM_PUSH_NODE_INFO_INTERVAL) {
            throw new IllegalArgumentException("parameter of nodeInfoPushInterval has to be more or equal than 30 sec");
        }
        this.nodeInfoPushInterval = nodeInfoPushInterval;
    }
}

