/*
 * Decompiled with CFR 0.152.
 */
package eventcenter.monitor.elasticsearch;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import eventcenter.monitor.elasticsearch.DateTimeTypeConverter;
import io.searchbox.client.JestClient;
import io.searchbox.client.JestClientFactory;
import io.searchbox.client.config.HttpClientConfig;
import java.io.Serializable;
import java.util.Date;

public class ElasticSearchClientFactory
implements Serializable {
    private String elasticHost;
    private Integer connTimeout;
    private Integer readTimeout;

    HttpClientConfig buildConfig() {
        HttpClientConfig.Builder builder = (HttpClientConfig.Builder)new HttpClientConfig.Builder(this.elasticHost).multiThreaded(true);
        if (null != this.connTimeout) {
            builder.connTimeout(this.connTimeout.intValue());
        }
        if (null != this.readTimeout) {
            builder.readTimeout(this.readTimeout.intValue());
        }
        Gson gson = new GsonBuilder().registerTypeAdapter(Date.class, (Object)new DateTimeTypeConverter()).create();
        builder.gson(gson);
        return builder.build();
    }

    public JestClient createClient() {
        JestClientFactory factory = new JestClientFactory();
        factory.setHttpClientConfig(this.buildConfig());
        return factory.getObject();
    }

    public String getElasticHost() {
        return this.elasticHost;
    }

    public void setElasticHost(String elasticHost) {
        this.elasticHost = elasticHost;
    }

    public Integer getConnTimeout() {
        return this.connTimeout;
    }

    public void setConnTimeout(Integer connTimeout) {
        this.connTimeout = connTimeout;
    }

    public Integer getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(Integer readTimeout) {
        this.readTimeout = readTimeout;
    }
}

