/*
 * Decompiled with CFR 0.152.
 */
package eventcenter.monitor.elasticsearch;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.Date;
import org.elasticsearch.common.joda.time.DateTime;
import org.elasticsearch.common.joda.time.format.ISODateTimeFormat;

public class DateTimeTypeConverter
implements JsonSerializer<Date>,
JsonDeserializer<Date> {
    public JsonElement serialize(Date src, Type srcType, JsonSerializationContext context) {
        DateTime date = new DateTime((Object)src);
        return new JsonPrimitive(date.toString());
    }

    public Date deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
        String value = json.getAsString();
        if (value.contains("+08:00")) {
            return ISODateTimeFormat.dateTime().parseDateTime(value).toDate();
        }
        return ISODateTimeFormat.dateTimeNoMillis().parseDateTime(value).toDate();
    }
}

