/*
 * Decompiled with CFR 0.152.
 */
package eventcenter.monitor;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import eventcenter.api.CommonEventSource;
import eventcenter.api.EventInfo;
import eventcenter.api.ListenerReceipt;
import eventcenter.monitor.NodeInfo;
import eventcenter.remote.Target;
import eventcenter.remote.publisher.PublisherGroup;
import java.io.Serializable;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.Enumeration;
import org.apache.log4j.Logger;

public class MonitorEventInfo
implements Serializable {
    private static final long serialVersionUID = 170864056603883355L;
    public static final Integer TYPE_CONSUMED = 0;
    public static final Integer TYPE_SEND = 1;
    public static final Integer TYPE_RECEIVED = 2;
    private static InetAddress clientIp;
    private String nodeId;
    private String nodeGroup;
    private String nodeHost;
    private String nodeName;
    private String fromNodeId;
    private Long took;
    private Long delay;
    private Throwable exception;
    private boolean success;
    private String listenerClazz;
    private Date created;
    private Date start;
    private Date consumed;
    private String eventArgs;
    private String eventResult;
    private String eventId;
    private String eventName;
    private String mdcValue;
    private Integer type = 0;
    private String sendHost;
    private String exceptionMessage;
    private String exceptionStack;

    public Long getTook() {
        return this.took;
    }

    public void setTook(Long took) {
        this.took = took;
    }

    public Throwable getException() {
        return this.exception;
    }

    public void setException(Throwable exception) {
        this.exception = exception;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public String getListenerClazz() {
        return this.listenerClazz;
    }

    public void setListenerClazz(String listenerClazz) {
        this.listenerClazz = listenerClazz;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    public Date getConsumed() {
        return this.consumed;
    }

    public void setConsumed(Date consumed) {
        this.consumed = consumed;
    }

    public String getFromNodeId() {
        return this.fromNodeId;
    }

    public void setFromNodeId(String fromNodeId) {
        this.fromNodeId = fromNodeId;
    }

    public String getEventArgs() {
        return this.eventArgs;
    }

    public void setEventArgs(String eventArgs) {
        this.eventArgs = eventArgs;
    }

    public String getEventResult() {
        return this.eventResult;
    }

    public void setEventResult(String eventResult) {
        this.eventResult = eventResult;
    }

    public String getEventId() {
        return this.eventId;
    }

    public void setEventId(String eventId) {
        this.eventId = eventId;
    }

    public String getEventName() {
        return this.eventName;
    }

    public void setEventName(String eventName) {
        this.eventName = eventName;
    }

    public String getMdcValue() {
        return this.mdcValue;
    }

    public void setMdcValue(String mdcValue) {
        this.mdcValue = mdcValue;
    }

    public Date getCreated() {
        return this.created;
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    public String getNodeGroup() {
        return this.nodeGroup;
    }

    public void setNodeGroup(String nodeGroup) {
        this.nodeGroup = nodeGroup;
    }

    public Date getStart() {
        return this.start;
    }

    public void setStart(Date start) {
        this.start = start;
    }

    public Long getDelay() {
        return this.delay;
    }

    public void setDelay(Long delay) {
        this.delay = delay;
    }

    public String getNodeHost() {
        return this.nodeHost;
    }

    public void setNodeHost(String nodeHost) {
        this.nodeHost = nodeHost;
    }

    public Integer getType() {
        return this.type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getSendHost() {
        return this.sendHost;
    }

    public void setSendHost(String sendHost) {
        this.sendHost = sendHost;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    public String getExceptionMessage() {
        return this.exceptionMessage;
    }

    public void setExceptionMessage(String exceptionMessage) {
        this.exceptionMessage = exceptionMessage;
    }

    public String getExceptionStack() {
        return this.exceptionStack;
    }

    public void setExceptionStack(String exceptionStack) {
        this.exceptionStack = exceptionStack;
    }

    private static InetAddress getSerIp() throws UnknownHostException {
        if (null != clientIp) {
            return clientIp;
        }
        try {
            Enumeration<NetworkInterface> allNetInterfaces = NetworkInterface.getNetworkInterfaces();
            InetAddress ip = null;
            while (allNetInterfaces.hasMoreElements()) {
                NetworkInterface netInterface = allNetInterfaces.nextElement();
                Enumeration<InetAddress> addresses = netInterface.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    ip = addresses.nextElement();
                    if (ip == null || !(ip instanceof Inet4Address) || ip.getHostAddress().equals("127.0.0.1")) continue;
                    clientIp = ip;
                    return ip;
                }
            }
        }
        catch (SocketException e) {
            Logger.getLogger(MonitorEventInfo.class).error((Object)e.getMessage(), (Throwable)e);
        }
        clientIp = Inet4Address.getLocalHost();
        return clientIp;
    }

    public static MonitorEventInfo buildSend(NodeInfo nodeInfo, PublisherGroup group, Target target, EventInfo eventInfo, Object eventResult, Exception e) {
        MonitorEventInfo info = new MonitorEventInfo();
        info.setType(TYPE_SEND);
        info.setConsumed(null);
        info.setStart(new Date());
        info.setDelay(null);
        info.setEventId(eventInfo.getId());
        info.setEventName(eventInfo.getName());
        info.setException(e);
        info.setMdcValue(eventInfo.getMdcValue());
        info.setNodeGroup(nodeInfo.getGroup());
        info.setNodeHost(nodeInfo.getHost());
        info.setNodeId(nodeInfo.getId());
        info.setNodeName(nodeInfo.getName());
        info.setSuccess(e == null);
        info.setSendHost(group.getRemoteUrl());
        try {
            info.setCreated(target.getCreated());
            if (null != target.getCreated()) {
                info.setTook(System.currentTimeMillis() - target.getCreated().getTime());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return info;
    }

    public static MonitorEventInfo buildReceived(NodeInfo nodeInfo, Target target, EventInfo eventInfo, Object eventResult) {
        MonitorEventInfo info = new MonitorEventInfo();
        info.setType(TYPE_RECEIVED);
        info.setConsumed(null);
        info.setStart(new Date());
        info.setEventId(eventInfo.getId());
        info.setEventName(eventInfo.getName());
        info.setMdcValue(eventInfo.getMdcValue());
        info.setNodeGroup(nodeInfo.getGroup());
        info.setNodeHost(nodeInfo.getHost());
        info.setNodeId(nodeInfo.getId());
        info.setNodeName(nodeInfo.getName());
        info.setFromNodeId(target.getNodeId());
        info.setSuccess(true);
        try {
            info.setCreated(target.getCreated());
            if (null != target.getCreated()) {
                info.setDelay(System.currentTimeMillis() - target.getCreated().getTime());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return info;
    }

    public static MonitorEventInfo buildWith(ListenerReceipt receipt, NodeInfo nodeInfo, Object eventArgs, Object eventResult) {
        MonitorEventInfo info = new MonitorEventInfo();
        info.setSuccess(receipt.isSuccess());
        info.setTook(receipt.getTook());
        info.setException(receipt.getException());
        info.setNodeId(nodeInfo.getId());
        info.setCreated(new Date(receipt.getEvt().getTimestamp()));
        info.setStart(receipt.getStart());
        if (null != info.getStart() && null != info.getCreated()) {
            info.setDelay(info.getStart().getTime() - info.getCreated().getTime());
        }
        if (null != receipt.getEventListener()) {
            info.setListenerClazz(receipt.getEventListener().getClass().getName());
        }
        info.setEventId(receipt.getEvt().getEventId());
        info.setEventName(receipt.getEvt().getEventName());
        info.setMdcValue(receipt.getEvt().getMdcValue());
        info.setNodeGroup(nodeInfo.getGroup());
        try {
            info.setNodeHost(MonitorEventInfo.getSerIp().getHostAddress());
        }
        catch (UnknownHostException e) {
            Logger.getLogger(MonitorEventInfo.class).error((Object)e.getMessage(), (Throwable)e);
        }
        if (receipt.getEvt() instanceof CommonEventSource) {
            CommonEventSource cevt = (CommonEventSource)receipt.getEvt();
            info.setEventArgs(eventArgs == null ? null : MonitorEventInfo.toJSONString(eventArgs));
            info.setEventResult(eventResult == null ? null : MonitorEventInfo.toJSONString(eventResult));
        }
        if (receipt.getEvt().getSourceInfo() instanceof Target) {
            Target target = (Target)receipt.getEvt().getSourceInfo();
            info.setFromNodeId(target.getNodeId());
        }
        return info;
    }

    private static String toJSONString(Object arg) {
        return JSON.toJSONString((Object)arg, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.UseISO8601DateFormat});
    }

    public static MonitorEventInfo buildWith(ListenerReceipt receipt, NodeInfo nodeInfo, Object eventArgs, Object eventResult, Date consumed) {
        MonitorEventInfo info = MonitorEventInfo.buildWith(receipt, nodeInfo, eventArgs, eventResult);
        info.setConsumed(consumed);
        return info;
    }
}

