/*
 * Decompiled with CFR 0.152.
 */
package eventcenter.monitor;

import eventcenter.monitor.MonitorDataCodec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public abstract class AbstractMonitorDataCodec
implements MonitorDataCodec {
    protected int maxLevel = 2;

    protected abstract Map<String, Object> codecElement(Object var1);

    @Override
    public Object codec(String eventName, Object data) {
        return this.codec(eventName, data, 0);
    }

    protected Object codec(String eventName, Object data, int level) {
        if (null == data) {
            return null;
        }
        if (!(data instanceof Collection || data instanceof Map || data instanceof Object[])) {
            Map<String, Object> result = this.codecElement(data);
            if (null == result) {
                return data;
            }
            return result;
        }
        if (level > this.maxLevel) {
            return data;
        }
        if (data instanceof Collection) {
            return this.codecCollection(eventName, (Collection)data, ++level);
        }
        if (data instanceof Object[]) {
            return this.codecArray(eventName, (Object[])data, ++level);
        }
        Map map = (Map)data;
        Set keys = map.keySet();
        HashMap<String, Object> result = new HashMap<String, Object>();
        ++level;
        for (Object key : keys) {
            String _key;
            Object val = map.get(key);
            if (null == val) continue;
            String string = _key = key == null ? "null" : key.toString();
            if (val instanceof Collection) {
                result.put(_key, this.codecCollection(eventName, (Collection)val, level));
                continue;
            }
            if (val instanceof Map) {
                result.put(_key, this.codec(eventName, val, level));
                continue;
            }
            if (val instanceof Object[]) {
                result.put(_key, this.codecArray(eventName, (Object[])val, level));
                continue;
            }
            Map<String, Object> codec = this.codecElement(val);
            if (null == codec) {
                result.put(_key, val);
                continue;
            }
            result.put(_key, codec);
        }
        return result;
    }

    @Override
    public Collection<Object> codecCollection(String eventName, Collection<?> collection) {
        return this.codecCollection(eventName, collection, 0);
    }

    protected Collection<Object> codecCollection(String eventName, Collection<?> collection, int level) {
        if (null == collection) {
            return null;
        }
        ArrayList<Object> result = new ArrayList<Object>(collection.size() + 1);
        for (Object obj : collection) {
            Object val = this.codec(eventName, obj, level);
            if (null == val) {
                result.add(obj);
                continue;
            }
            result.add(val);
        }
        return result;
    }

    protected Collection<Object> codecArray(String eventName, Object[] array, int level) {
        if (null == array) {
            return null;
        }
        ArrayList<Object> result = new ArrayList<Object>(array.length + 1);
        for (Object obj : array) {
            Object val = this.codec(eventName, obj, level);
            if (null == val) {
                result.add(obj);
                continue;
            }
            result.add(val);
        }
        return result;
    }

    public int getMaxLevel() {
        return this.maxLevel;
    }

    public void setMaxLevel(int maxLevel) {
        this.maxLevel = maxLevel;
    }

    public static class Builder {
        private Map<String, Object> result = new HashMap<String, Object>();

        public Builder append(String key, Object value) {
            this.result.put(key, value);
            return this;
        }

        public Map<String, Object> build() {
            return this.result;
        }
    }
}

