/*
 * Decompiled with CFR 0.152.
 */
package eventcenter.monitor;

import eventcenter.api.AbstractEventCenter;
import eventcenter.api.CommonEventSource;
import eventcenter.api.ListenerReceipt;
import eventcenter.api.appcache.IdentifyContext;
import eventcenter.monitor.ControlMonitor;
import eventcenter.monitor.InfoForward;
import eventcenter.monitor.InfoStorage;
import eventcenter.monitor.MonitorDataCodec;
import eventcenter.monitor.MonitorEventInfo;
import eventcenter.monitor.MonitorStorageException;
import eventcenter.monitor.NodeInfo;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Date;
import java.util.Enumeration;
import java.util.UUID;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import org.apache.log4j.Logger;

public abstract class AbstractControlMonitor
implements ControlMonitor {
    protected static final DelayInitLock delayInitLock = new DelayInitLock();
    protected InfoForward infoForward;
    protected InfoStorage infoStorage;
    protected NodeInfo nodeInfo;
    protected String nodeName;
    protected MonitorDataCodec monitorDataCodec;
    protected String monitorDataCodecClazz;
    @Resource
    protected AbstractEventCenter eventCenter;
    protected boolean saveEventData = false;
    protected String group;
    protected volatile boolean open = false;
    protected boolean uploadNodeInfoError = false;
    protected HeartBeat heartBeat;
    protected long heartbeatInterval = 10000L;
    protected final Logger logger = Logger.getLogger(this.getClass());

    public String getNodeName() {
        return this.nodeName;
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    public InfoStorage getInfoStorage() {
        return this.infoStorage;
    }

    public void setInfoStorage(InfoStorage infoStorage) {
        this.infoStorage = infoStorage;
    }

    public InfoForward getInfoForward() {
        return this.infoForward;
    }

    public void setInfoForward(InfoForward infoForward) {
        this.infoForward = infoForward;
    }

    public MonitorDataCodec getMonitorDataCodec() {
        return this.monitorDataCodec;
    }

    public void setMonitorDataCodec(MonitorDataCodec monitorDataCodec) {
        this.monitorDataCodec = monitorDataCodec;
    }

    public String getMonitorDataCodecClazz() {
        return this.monitorDataCodecClazz;
    }

    public void setMonitorDataCodecClazz(String monitorDataCodecClazz) {
        this.monitorDataCodecClazz = monitorDataCodecClazz;
    }

    @Override
    @PostConstruct
    public void startup() {
        if (this.open || delayInitLock.isLock()) {
            return;
        }
        this.init();
        this.openHeartBeat();
    }

    protected void init() {
        if (this.open || delayInitLock.isLock()) {
            return;
        }
        if (null == this.infoStorage) {
            this.infoStorage = this.loadInfoStorage();
            try {
                this.infoStorage.open();
            }
            catch (Exception e) {
                throw new MonitorStorageException(e);
            }
        }
        if (null == this.monitorDataCodec && null != this.monitorDataCodecClazz) {
            try {
                this.monitorDataCodec = this.instanceCodec(this.monitorDataCodecClazz);
            }
            catch (Exception e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        this.nodeInfo = this.loadNodeInfo();
        this.open = true;
    }

    protected void openHeartBeat() {
        if (null != this.heartBeat) {
            return;
        }
        if (null == this.infoForward) {
            throw new IllegalArgumentException("please set infoForward for monitor");
        }
        this.heartBeat = new HeartBeat();
        Thread heartBeatThread = new Thread((Runnable)this.heartBeat, "ec-monitor-heartbeart");
        heartBeatThread.start();
    }

    @Override
    @PreDestroy
    public void shutdown() {
        try {
            if (null != this.heartBeat) {
                this.heartBeat.shutdown();
            }
            this.infoStorage.close();
            this.heartBeat = null;
            this.infoForward = null;
        }
        catch (Exception e) {
            throw new MonitorStorageException(e);
        }
        this.open = false;
    }

    protected void assertInfoStorageNotNull() {
        if (null == this.infoStorage) {
            throw new IllegalArgumentException("please init infoStorage when save event info for monitor");
        }
    }

    protected MonitorDataCodec instanceCodec(String clazz) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Class<?> clzInfo = Class.forName(clazz);
        Constructor<?> constructor = clzInfo.getConstructor(new Class[0]);
        return (MonitorDataCodec)constructor.newInstance(new Object[0]);
    }

    protected abstract InfoStorage loadInfoStorage();

    @Override
    public void saveEventInfo(MonitorEventInfo mei) {
        this.assertInfoStorageNotNull();
        this.infoStorage.pushEventInfo(mei);
    }

    protected NodeInfo loadNodeInfo() {
        NodeInfo info = this.queryNodeInfo(false);
        if (null == info) {
            info = new NodeInfo();
            try {
                info.setId(IdentifyContext.getId());
            }
            catch (IOException e) {
                this.logger.error((Object)("get identify id error:" + e.getMessage()));
                info.setId(UUID.randomUUID().toString());
            }
        }
        info.setGroup(this.group);
        InetAddress hostAddress = this.getHostAddress();
        info.setHost(hostAddress.getHostAddress());
        if (info.getName() == null) {
            if (null == this.nodeName) {
                info.setName(hostAddress.getHostName());
            } else {
                info.setName(hostAddress.getHostName() + "_" + this.nodeName);
            }
        }
        info.setStart(new Date());
        info.setStat(1);
        return info;
    }

    @Override
    public NodeInfo queryNodeInfo(boolean includeDetail) {
        if (!includeDetail) {
            return this.nodeInfo;
        }
        this.nodeInfo.setCountOfQueueBuffer(this.countOfQueueBuffer());
        this.nodeInfo.setQueueSize(this.queueSize());
        this.nodeInfo.setCountOfLiveThread(this.countOfLiveThread());
        return this.nodeInfo;
    }

    protected InetAddress getHostAddress() {
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                NetworkInterface networkInterface = interfaces.nextElement();
                if (networkInterface.isLoopback() || networkInterface.isVirtual() || !networkInterface.isUp()) continue;
                Enumeration<InetAddress> addresses = networkInterface.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress inetAddress = addresses.nextElement();
                    if (!(inetAddress instanceof Inet4Address)) continue;
                    return inetAddress;
                }
            }
        }
        catch (SocketException e) {
            this.logger.error((Object)("Error when getting host ip address: <" + e.getMessage() + ">."));
        }
        return null;
    }

    @Override
    public void saveListenerReceipt(ListenerReceipt receipt) {
        NodeInfo nodeInfo = this.queryNodeInfo(false);
        if (null == nodeInfo) {
            this.logger.error((Object)"can't query node info from controlMonitor");
            return;
        }
        MonitorEventInfo monitorEventInfo = null;
        try {
            if (receipt.getEvt() instanceof CommonEventSource && this.saveEventData) {
                CommonEventSource evt = (CommonEventSource)receipt.getEvt();
                Object eventArgs = this.codecObject(evt.getEventName(), evt.getArgs());
                Object eventResult = this.codecObject(evt.getEventName(), evt.getResult());
                monitorEventInfo = MonitorEventInfo.buildWith(receipt, nodeInfo, eventArgs, eventResult, new Date());
            } else {
                monitorEventInfo = MonitorEventInfo.buildWith(receipt, nodeInfo, null, null, new Date());
            }
        }
        catch (Throwable e) {
            this.logger.error((Object)new StringBuilder("build monitorEventInfo error:").append(e.getMessage()));
        }
        if (null != monitorEventInfo) {
            this.saveEventInfo(monitorEventInfo);
        }
    }

    public Object codecObject(String eventName, Object v) {
        if (null == this.monitorDataCodec) {
            return v;
        }
        try {
            return this.monitorDataCodec.codec(eventName, v);
        }
        catch (Exception e) {
            this.logger.error((Object)("codec event args error:" + e.getMessage()), (Throwable)e);
            return v;
        }
    }

    @Override
    public int queueSize() {
        return this.eventCenter.getAsyncContainer().queueSize();
    }

    @Override
    public int countOfMaxConcurrent() {
        return this.eventCenter.getAsyncContainer().countOfMaxConcurrent();
    }

    @Override
    public int countOfLiveThread() {
        return this.eventCenter.getAsyncContainer().countOfLiveThread();
    }

    @Override
    public int countOfQueueBuffer() {
        return this.eventCenter.getAsyncContainer().countOfQueueBuffer();
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public AbstractEventCenter getEventCenter() {
        return this.eventCenter;
    }

    public void setEventCenter(AbstractEventCenter eventCenter) {
        this.eventCenter = eventCenter;
    }

    public boolean isSaveEventData() {
        return this.saveEventData;
    }

    public void setSaveEventData(boolean saveEventData) {
        this.saveEventData = saveEventData;
    }

    public long getHeartbeatInterval() {
        return this.heartbeatInterval;
    }

    public void setHeartbeatInterval(long heartbeatInterval) {
        this.heartbeatInterval = heartbeatInterval;
    }

    protected static class DelayInitLock {
        ThreadLocal<Integer> stat = new ThreadLocal();

        protected DelayInitLock() {
        }

        public void lock() {
            this.stat.set(1);
        }

        public void unlock() {
            this.stat.remove();
        }

        public boolean isLock() {
            return this.stat.get() != null;
        }
    }

    public class HeartBeat
    implements Runnable {
        protected volatile boolean beatOpen = true;
        protected final Object lock = new Object();

        @Override
        public void run() {
            while (AbstractControlMonitor.this.open && this.beatOpen) {
                try {
                    AbstractControlMonitor.this.infoForward.forwardNodeInfo(AbstractControlMonitor.this.queryNodeInfo(true));
                }
                catch (Exception e) {
                    AbstractControlMonitor.this.logger.error((Object)new StringBuilder("send heartbeat error:").append(e.getMessage()), (Throwable)e);
                }
                this.sleep(AbstractControlMonitor.this.heartbeatInterval);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown() {
            this.beatOpen = false;
            Object object = this.lock;
            synchronized (object) {
                this.lock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void sleep(long sleepTime) {
            Object object = this.lock;
            synchronized (object) {
                try {
                    this.lock.wait(sleepTime);
                }
                catch (InterruptedException e) {
                    AbstractControlMonitor.this.logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }
}

