/*
 * Decompiled with CFR 0.152.
 */
package eventcenter.monitor.client.leveldb;

import eventcenter.api.utils.IdWorker;
import eventcenter.api.utils.SerializeUtils;
import eventcenter.monitor.InfoStorage;
import eventcenter.monitor.MonitorEventInfo;
import eventcenter.monitor.MonitorException;
import eventcenter.monitor.MonitorStorageException;
import eventcenter.monitor.NodeInfo;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;
import org.fusesource.leveldbjni.JniDBFactory;
import org.iq80.leveldb.CompressionType;
import org.iq80.leveldb.DB;
import org.iq80.leveldb.DBIterator;
import org.iq80.leveldb.Options;
import org.iq80.leveldb.WriteBatch;

public class LeveldbInfoStorage
implements InfoStorage {
    static final String PREFIX_EVENT_INFO = "ei";
    static final String KEY_NODE_INFO = "node_info";
    private String name;
    private File dirPath;
    private Integer blockRestartInterval;
    private Integer blockSize;
    private Long cacheSize;
    private Boolean useSnappyCompression;
    private Integer maxOpenFiles;
    private Boolean paranoidChecks;
    private Boolean verifyChecksums;
    private Integer writeBufferSize;
    private Integer batchDeleteSize = 1000;
    protected DB db;
    protected final Logger logger = Logger.getLogger(this.getClass());
    protected IdWorker idWorker;
    protected final ReentrantLock readLock = new ReentrantLock();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public File getDirPath() {
        if (null == this.dirPath) {
            String path = System.getProperty("user.home") + File.separator + ".ecmonitor";
            this.dirPath = new File(path);
        }
        return this.dirPath;
    }

    public void setDirPath(File dirPath) {
        this.dirPath = dirPath;
    }

    public Integer getBlockRestartInterval() {
        return this.blockRestartInterval;
    }

    public void setBlockRestartInterval(Integer blockRestartInterval) {
        this.blockRestartInterval = blockRestartInterval;
    }

    public Integer getBlockSize() {
        return this.blockSize;
    }

    public void setBlockSize(Integer blockSize) {
        this.blockSize = blockSize;
    }

    public Long getCacheSize() {
        return this.cacheSize;
    }

    public void setCacheSize(Long cacheSize) {
        this.cacheSize = cacheSize;
    }

    public Boolean getUseSnappyCompression() {
        return this.useSnappyCompression;
    }

    public void setUseSnappyCompression(Boolean useSnappyCompression) {
        this.useSnappyCompression = useSnappyCompression;
    }

    public Integer getMaxOpenFiles() {
        return this.maxOpenFiles;
    }

    public void setMaxOpenFiles(Integer maxOpenFiles) {
        this.maxOpenFiles = maxOpenFiles;
    }

    public Boolean getParanoidChecks() {
        return this.paranoidChecks;
    }

    public void setParanoidChecks(Boolean paranoidChecks) {
        this.paranoidChecks = paranoidChecks;
    }

    public Boolean getVerifyChecksums() {
        return this.verifyChecksums;
    }

    public void setVerifyChecksums(Boolean verifyChecksums) {
        this.verifyChecksums = verifyChecksums;
    }

    public Integer getWriteBufferSize() {
        return this.writeBufferSize;
    }

    public void setWriteBufferSize(Integer writeBufferSize) {
        this.writeBufferSize = writeBufferSize;
    }

    public Integer getBatchDeleteSize() {
        return this.batchDeleteSize;
    }

    public void setBatchDeleteSize(Integer batchDeleteSize) {
        this.batchDeleteSize = batchDeleteSize;
    }

    protected Options createOptions() {
        Options options = new Options();
        if (null != this.blockRestartInterval) {
            options.blockRestartInterval(this.blockRestartInterval.intValue());
        }
        if (null != this.blockSize) {
            options.blockSize(this.blockSize.intValue());
        }
        if (null != this.cacheSize) {
            options.cacheSize(this.cacheSize.longValue());
        }
        if (null != this.useSnappyCompression && this.useSnappyCompression.booleanValue()) {
            options.compressionType(CompressionType.SNAPPY);
        }
        if (null != this.maxOpenFiles) {
            options.maxOpenFiles(this.maxOpenFiles.intValue());
        }
        if (null != this.paranoidChecks) {
            options.paranoidChecks(this.paranoidChecks.booleanValue());
        }
        if (null != this.verifyChecksums) {
            options.verifyChecksums(this.verifyChecksums.booleanValue());
        }
        if (null != this.writeBufferSize) {
            options.writeBufferSize(this.writeBufferSize.intValue());
        }
        return options;
    }

    public void open() throws Exception {
        if (this.db != null) {
            return;
        }
        this.idWorker = new IdWorker(1L);
        Options options = this.createOptions();
        File dirPath = this.getDirPath();
        if (!dirPath.exists()) {
            dirPath.mkdirs();
        }
        this.db = JniDBFactory.factory.open(dirPath, options);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("open leveldb for info storage success, path:" + dirPath.getCanonicalPath()));
        }
    }

    public void close() throws Exception {
        if (this.db == null) {
            return;
        }
        this.db.close();
        this.db = null;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"closed leveldb for info storage success");
        }
    }

    protected void assertDbOpen() {
        if (null == this.db) {
            new MonitorException("leveldb didn't open");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void pushEventInfos(List<MonitorEventInfo> infos) {
        this.assertDbOpen();
        WriteBatch batch = this.db.createWriteBatch();
        try {
            for (MonitorEventInfo info : infos) {
                String id = String.valueOf(this.idWorker.nextId());
                try {
                    batch.put(this.generateEventInfoKey(id).getBytes(), SerializeUtils.serialize((Serializable)info));
                }
                catch (IOException e) {
                    throw new MonitorStorageException((Throwable)e);
                    return;
                }
            }
        }
        finally {
            this.db.write(batch);
            try {
                batch.close();
            }
            catch (IOException e) {
                throw new MonitorStorageException((Throwable)e);
            }
        }
    }

    public void pushEventInfo(MonitorEventInfo info) {
        this.assertDbOpen();
        this.pushEventInfos(Arrays.asList(info));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<MonitorEventInfo> popEventInfos(int maxSize) {
        this.assertDbOpen();
        ArrayList<MonitorEventInfo> list = new ArrayList<MonitorEventInfo>(maxSize + 1);
        ReentrantLock lock = this.readLock;
        lock.lock();
        WriteBatch batch = this.db.createWriteBatch();
        try {
            DBIterator iterator = this.db.iterator();
            iterator.seekToFirst();
            int index = 0;
            try {
                while (index < maxSize && iterator.hasNext()) {
                    Map.Entry element = (Map.Entry)iterator.next();
                    try {
                        String key = new String((byte[])element.getKey());
                        if (key.indexOf(PREFIX_EVENT_INFO) == -1) continue;
                        list.add((MonitorEventInfo)SerializeUtils.unserialize((byte[])((byte[])element.getValue())));
                        ++index;
                        batch.delete((byte[])element.getKey());
                    }
                    catch (IOException e) {
                        throw new MonitorStorageException((Throwable)e);
                    }
                }
            }
            finally {
                try {
                    iterator.close();
                }
                catch (IOException e) {
                    this.logger.error((Object)new StringBuilder("when close leveldb iterator happened error:").append(e.getMessage()), (Throwable)e);
                }
            }
            this.db.write(batch);
            return list;
        }
        finally {
            try {
                batch.close();
            }
            catch (Exception e) {
                this.logger.error((Object)new StringBuilder("when close leveldb writeBatch happened error:").append(e.getMessage()), (Throwable)e);
            }
            lock.unlock();
        }
    }

    public MonitorEventInfo popEventInfo() {
        this.assertDbOpen();
        List<MonitorEventInfo> list = this.popEventInfos(1);
        if (list.size() == 0) {
            return null;
        }
        return list.get(0);
    }

    public void saveNodeInfo(NodeInfo nodeInfo) {
        this.assertDbOpen();
        try {
            this.db.put(KEY_NODE_INFO.getBytes(), SerializeUtils.serialize((Serializable)nodeInfo));
        }
        catch (IOException e) {
            throw new MonitorStorageException((Throwable)e);
        }
    }

    public NodeInfo queryNodeInfo() {
        this.assertDbOpen();
        byte[] bytes = this.db.get(KEY_NODE_INFO.getBytes());
        if (null == bytes || bytes.length == 0) {
            return null;
        }
        try {
            return (NodeInfo)SerializeUtils.unserialize((byte[])bytes);
        }
        catch (IOException e) {
            throw new MonitorStorageException((Throwable)e);
        }
    }

    protected String generateKey(String prefix, String key) {
        return prefix + "_" + key;
    }

    protected String generateEventInfoKey(String key) {
        return this.generateKey(PREFIX_EVENT_INFO, key);
    }
}

