/*
 * Decompiled with CFR 0.152.
 */
package eventcenter.monitor.client.filter;

import eventcenter.api.EventInfo;
import eventcenter.monitor.ControlMonitor;
import eventcenter.monitor.MonitorEventInfo;
import eventcenter.monitor.NodeInfo;
import eventcenter.remote.Target;
import eventcenter.remote.publisher.PublishFilter;
import eventcenter.remote.publisher.PublisherGroup;
import eventcenter.remote.subscriber.SubscribFilter;
import javax.annotation.Resource;
import org.apache.log4j.Logger;

public class RemoteFilter
implements PublishFilter,
SubscribFilter {
    @Resource
    private ControlMonitor controlMonitor;
    private final Logger logger = Logger.getLogger(this.getClass());

    public boolean afterSend(PublisherGroup group, Target target, EventInfo eventInfo, Object result, Exception e) {
        if (null == this.controlMonitor) {
            this.logger.error((Object)"RemoteFilter didn't set controlMonitor!");
            return true;
        }
        NodeInfo nodeInfo = this.controlMonitor.queryNodeInfo(false);
        if (null == nodeInfo) {
            this.logger.error((Object)"can't query node info from controlMonitor");
            return true;
        }
        MonitorEventInfo monitorEventInfo = MonitorEventInfo.buildSend((NodeInfo)nodeInfo, (PublisherGroup)group, (Target)target, (EventInfo)eventInfo, (Object)result, (Exception)e);
        this.controlMonitor.saveEventInfo(monitorEventInfo);
        return true;
    }

    public boolean afterReceived(Target target, EventInfo eventInfo, Object result) {
        if (null == this.controlMonitor) {
            this.logger.error((Object)"RemoteFilter didn't set controlMonitor!");
            return true;
        }
        NodeInfo nodeInfo = this.controlMonitor.queryNodeInfo(false);
        if (null == nodeInfo) {
            this.logger.error((Object)"can't query node info from controlMonitor");
            return true;
        }
        MonitorEventInfo monitorEventInfo = MonitorEventInfo.buildReceived((NodeInfo)nodeInfo, (Target)target, (EventInfo)eventInfo, (Object)result);
        this.controlMonitor.saveEventInfo(monitorEventInfo);
        return true;
    }

    public ControlMonitor getControlMonitor() {
        return this.controlMonitor;
    }

    public void setControlMonitor(ControlMonitor controlMonitor) {
        this.controlMonitor = controlMonitor;
    }
}

