/*
 * Decompiled with CFR 0.152.
 */
package eventcenter.monitor.client;

import eventcenter.api.ListenerReceipt;
import eventcenter.monitor.AbstractControlMonitor;
import eventcenter.monitor.AdapterInfoStorage;
import eventcenter.monitor.ControlMonitor;
import eventcenter.monitor.InfoStorage;
import eventcenter.monitor.MonitorEventInfo;
import eventcenter.remote.utils.StringHelper;
import java.util.HashSet;
import java.util.Set;

public class MixingControlMonitor
extends AbstractControlMonitor {
    Set<AbstractControlMonitor> monitors;

    public MixingControlMonitor() {
        delayInitLock.lock();
    }

    protected InfoStorage loadInfoStorage() {
        return new AdapterInfoStorage();
    }

    public void startup() {
        if (this.open) {
            return;
        }
        delayInitLock.unlock();
        if (this.getMonitors().size() == 0) {
            throw new IllegalArgumentException("please set parameter of monitors");
        }
        this.nodeInfo = this.loadNodeInfo();
        for (AbstractControlMonitor monitor : this.getMonitors()) {
            if (StringHelper.isEmpty((String)monitor.getGroup())) {
                monitor.setGroup(this.getGroup());
            }
            if (StringHelper.isEmpty((String)monitor.getNodeName())) {
                monitor.setNodeName(this.getNodeName());
            }
            monitor.startup();
        }
        this.open = true;
    }

    public void shutdown() {
        if (!this.open) {
            return;
        }
        for (ControlMonitor controlMonitor : this.getMonitors()) {
            controlMonitor.shutdown();
        }
        this.open = false;
    }

    public void saveEventInfo(MonitorEventInfo mei) {
        for (ControlMonitor controlMonitor : this.getMonitors()) {
            try {
                controlMonitor.saveEventInfo(mei);
            }
            catch (Exception e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public void saveListenerReceipt(ListenerReceipt receipt) {
        for (ControlMonitor controlMonitor : this.getMonitors()) {
            try {
                controlMonitor.saveListenerReceipt(receipt);
            }
            catch (Exception e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public Set<AbstractControlMonitor> getMonitors() {
        if (null == this.monitors) {
            this.monitors = new HashSet<AbstractControlMonitor>();
        }
        return this.monitors;
    }

    public void setMonitors(Set<AbstractControlMonitor> monitors) {
        this.monitors = monitors;
    }
}

