/*
 * Decompiled with CFR 0.152.
 */
package eventcenter.monitor.client;

import eventcenter.monitor.AbstractControlMonitor;
import eventcenter.monitor.InfoForward;
import eventcenter.monitor.InfoStorage;
import eventcenter.monitor.MonitorEventInfo;
import eventcenter.monitor.client.leveldb.LeveldbInfoStorage;
import java.io.File;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;

public class DefaultControlMonitor
extends AbstractControlMonitor {
    protected long checkInterval = 10000L;
    protected long nextPushInterval = 1000L;
    protected int batchForwardSize = 10;
    protected String dirPath;
    protected WatchDog watchDog;

    protected InfoStorage loadInfoStorage() {
        LeveldbInfoStorage storage = new LeveldbInfoStorage();
        if (null != this.dirPath) {
            storage.setDirPath(new File(this.dirPath + File.separator + ".ecmonitor"));
        }
        return storage;
    }

    @PostConstruct
    public void startup() {
        super.startup();
        this.watchDog = new WatchDog(this.infoForward);
        Thread t = new Thread((Runnable)this.watchDog, "ec-monitor-event-watchdog");
        t.start();
    }

    @PreDestroy
    public void shutdown() {
        super.shutdown();
        this.watchDog.shutdown();
    }

    public long getCheckInterval() {
        return this.checkInterval;
    }

    public void setCheckInterval(long checkInterval) {
        this.checkInterval = checkInterval;
    }

    public long getNextPushInterval() {
        return this.nextPushInterval;
    }

    public void setNextPushInterval(long nextPushInterval) {
        this.nextPushInterval = nextPushInterval;
    }

    public int getBatchForwardSize() {
        return this.batchForwardSize;
    }

    public void setBatchForwardSize(int batchForwardSize) {
        this.batchForwardSize = batchForwardSize;
    }

    public String getDirPath() {
        return this.dirPath;
    }

    public void setDirPath(String dirPath) {
        this.dirPath = dirPath;
    }

    public class WatchDog
    implements Runnable {
        protected final InfoForward infoForward;
        protected List<MonitorEventInfo> lastFailInfos;
        protected volatile boolean watchOpen = true;
        protected final Object lock = new Object();

        public WatchDog(InfoForward infoForward) {
            this.infoForward = infoForward;
        }

        @Override
        public void run() {
            while (DefaultControlMonitor.this.open && this.watchOpen) {
                try {
                    this.executing();
                }
                catch (Throwable e) {
                    DefaultControlMonitor.this.logger.error((Object)new StringBuilder("infoForward forward monitor info failure:").append(e.getMessage()));
                }
                this.sleep(DefaultControlMonitor.this.checkInterval);
            }
        }

        void executing() throws Throwable {
            if (null != this.lastFailInfos) {
                this.forward(this.lastFailInfos);
                this.lastFailInfos = null;
            }
            this.lastFailInfos = DefaultControlMonitor.this.infoStorage.popEventInfos(DefaultControlMonitor.this.batchForwardSize);
            while (DefaultControlMonitor.this.open && this.watchOpen) {
                if (this.lastFailInfos.size() == 0) {
                    this.sleep(DefaultControlMonitor.this.nextPushInterval);
                } else {
                    this.forward(this.lastFailInfos);
                }
                this.lastFailInfos = DefaultControlMonitor.this.infoStorage.popEventInfos(DefaultControlMonitor.this.batchForwardSize);
            }
            this.lastFailInfos = null;
        }

        void forward(List<MonitorEventInfo> infos) throws Throwable {
            try {
                this.infoForward.forwardEventInfo(infos);
            }
            catch (Throwable e) {
                this.lastFailInfos = infos;
                throw e;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown() {
            this.watchOpen = false;
            Object object = this.lock;
            synchronized (object) {
                this.lock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void sleep(long sleepTime) {
            Object object = this.lock;
            synchronized (object) {
                try {
                    this.lock.wait(sleepTime);
                }
                catch (InterruptedException e) {
                    DefaultControlMonitor.this.logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }
}

