/*
 * Decompiled with CFR 0.152.
 */
package eventcenter.builder.dubbo;

import eventcenter.api.EventCenter;
import eventcenter.api.support.DefaultEventCenter;
import eventcenter.builder.EventCenterBuilder;
import eventcenter.builder.ExampleService;
import eventcenter.builder.InitBuilder;
import eventcenter.builder.PublisherConfig;
import eventcenter.builder.dubbo.DubboConfigContext;
import eventcenter.builder.dubbo.DubboPublisherConfigBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.UUID;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.MDC;

public class AutowiredPublisherWithoutSpringMain1 {
    public static void main(String[] args) throws Exception {
        BasicConfigurator.configure();
        System.setProperty("ec.appdata.path", "." + File.separator + "target");
        DubboConfigContext.getInstance().applicationName("ec-sample-publisher").registryProtocol("zookeeper").registryAddress("localhost:2181").groupName("test");
        DefaultEventCenter eventCenter = new EventCenterBuilder().addEventListeners(InitBuilder.buildEventListeners()).publisher((PublisherConfig)new DubboPublisherConfigBuilder().addLocalPublisherGroup("example.manual").devMode(Boolean.valueOf(true)).subscriberAutowired(Boolean.valueOf(true)).build()).build();
        eventCenter.startup();
        ExampleService es = new ExampleService();
        es.setEventCenter((EventCenter)eventCenter);
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        String line = reader.readLine();
        do {
            AutowiredPublisherWithoutSpringMain1.handleCommand(line, es);
        } while ((line = reader.readLine()) != null && !line.equals("quit") && !line.equals("exit"));
        eventCenter.shutdown();
    }

    private static void handleCommand(String line, ExampleService es) {
        MDC.put((String)"clueId", (Object)UUID.randomUUID().toString());
        if (line.trim().equals("")) {
            es.manualFireEvent("Hello", 1);
        } else if (line.trim().equals("1")) {
            es.annotationFireEvent("Jacky", 2);
        }
    }
}

