/*
 * Decompiled with CFR 0.152.
 */
package eventcenter.monitor;

import eventcenter.monitor.ExampleService;
import eventcenter.monitor.Order;
import eventcenter.monitor.Trade;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.UUID;
import org.apache.log4j.MDC;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class PublisherMain {
    public static void main(String[] args) throws IOException {
        System.setProperty("ec.appdata.path", "." + File.separator + "target" + File.separator + "monitor" + File.separator + "pub");
        System.setProperty("dubbo.registry.address", "zookeeper://localhost:2181");
        System.setProperty("dubbo.application.name", "ec-dubbo-publisher");
        System.setProperty("dubbo.service.group", "test");
        ClassPathXmlApplicationContext ctx = new ClassPathXmlApplicationContext("/spring/monitor/spring-ec-publisher.xml");
        System.out.println("\u53d1\u5e03\u7aef\u542f\u52a8\u6210\u529f");
        ExampleService es = (ExampleService)ctx.getBean(ExampleService.class);
        int count = 100000;
        System.out.println("\u6b63\u5728\u5f00\u59cb\u6267\u884c\u538b\u529b\u6d4b\u8bd5");
        for (int i = 0; i < count; ++i) {
            PublisherMain.handleCommand("", es);
        }
        System.out.println("\u538b\u529b\u6d4b\u8bd5\u7ed3\u675f\uff0c\u603b\u5171\u53d1\u9001\u4e8b\u4ef6\u6570:" + count);
        System.out.println("\u8bf7\u6572\u5165\u56de\u8f66\uff0c\u8c03\u7528manualFireEvent\uff0c\u6572\u51651\uff0c\u7136\u540e\u56de\u8f66\uff0c\u8c03\u7528annotationFireEvent\uff0c\u9000\u51fa\u8bf7\u6572\u5165quit");
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        String line = reader.readLine();
        do {
            PublisherMain.handleCommand(line, es);
        } while ((line = reader.readLine()) != null && !line.equals("quit") && !line.equals("exit"));
    }

    private static void handleCommand(String line, ExampleService es) {
        MDC.put((String)"clueId", (Object)UUID.randomUUID().toString());
        if (line.trim().equals("")) {
            es.manualFireEvent("Hello", 1);
        } else if (line.trim().equals("1")) {
            es.annotationFireEvent("Jacky", 2);
        } else if (line.trim().startsWith("2")) {
            Trade t = PublisherMain.createTrade(null, null, null);
            es.consignTrade(t);
        }
    }

    private static Trade createTrade(String buyerNick, String sellerNick, String status) {
        Trade t = new Trade();
        t.setBuyerNick(buyerNick);
        t.setId(UUID.randomUUID().toString());
        t.setTid(UUID.randomUUID().toString());
        t.setStatus(status);
        t.setOutSid(UUID.randomUUID().toString());
        t.setSellerNick(sellerNick);
        ArrayList<Order> orders = new ArrayList<Order>();
        Order order = new Order();
        order.setId(UUID.randomUUID().toString());
        order.setTid(t.getTid());
        order.setNumIid(UUID.randomUUID().toString());
        order.setTitle("\u6d4b\u8bd5");
        orders.add(order);
        t.setOrders(orders);
        return t;
    }
}

