/*
 * Decompiled with CFR 0.152.
 */
package io.etrace.agent.stat;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

public class TCPStats {
    private AtomicLong totalSize = new AtomicLong(0L);
    private AtomicLong tcpLoss = new AtomicLong(0L);
    private AtomicLong lossInNet = new AtomicLong(0L);
    private AtomicLong lossSize = new AtomicLong(0L);
    private AtomicLong tcpPollCount = new AtomicLong(0L);
    private AtomicLong successCount = new AtomicLong(0L);
    private AtomicLong timeoutCount = new AtomicLong(0L);

    public void incTotalSize(int totalSize) {
        this.totalSize.addAndGet(totalSize);
    }

    public void incTcpLoss(int loss) {
        this.tcpLoss.addAndGet(loss);
    }

    public void incLossSize(int lossSize) {
        this.lossSize.addAndGet(lossSize);
    }

    public void incTcpPollCount(int tcpPollCount) {
        this.tcpPollCount.addAndGet(tcpPollCount);
    }

    public void incLossInNet(int lossInNet) {
        this.lossInNet.addAndGet(lossInNet);
    }

    public void incSuccessCount(int count) {
        this.successCount.addAndGet(count);
    }

    public void incTimeoutCount(int count) {
        this.timeoutCount.addAndGet(count);
    }

    public long getTotalSize() {
        return this.totalSize.get();
    }

    public long getTcpLoss() {
        return this.tcpLoss.get();
    }

    public long getLossInNet() {
        return this.lossInNet.get();
    }

    public long getLossSize() {
        return this.lossSize.get();
    }

    public long getSuccessCount() {
        return this.successCount.get();
    }

    public long getTcpPollCount() {
        return this.tcpPollCount.get();
    }

    public long getTimeoutCount() {
        return this.timeoutCount.get();
    }

    public TCPStats copyStats() {
        TCPStats TCPStats2 = new TCPStats();
        TCPStats2.totalSize.addAndGet(this.getTotalSize());
        TCPStats2.tcpLoss.addAndGet(this.getTcpLoss());
        TCPStats2.lossInNet.addAndGet(this.getLossInNet());
        TCPStats2.lossSize.addAndGet(this.getLossSize());
        TCPStats2.tcpPollCount.addAndGet(this.getTcpPollCount());
        TCPStats2.successCount.addAndGet(this.getSuccessCount());
        TCPStats2.timeoutCount.addAndGet(this.getTimeoutCount());
        return TCPStats2;
    }

    public void decrement(TCPStats tcpStats) {
        this.update(tcpStats, -1);
    }

    public void inc(TCPStats tcpStats) {
        this.update(tcpStats, 1);
    }

    private void update(TCPStats tcpStats, int sign) {
        this.totalSize.addAndGet(tcpStats.totalSize.get() * (long)sign);
        this.tcpLoss.addAndGet(tcpStats.tcpLoss.get() * (long)sign);
        this.lossInNet.addAndGet(tcpStats.lossInNet.get() * (long)sign);
        this.lossSize.addAndGet(tcpStats.lossSize.get() * (long)sign);
        this.tcpPollCount.addAndGet(tcpStats.tcpPollCount.get() * (long)sign);
        this.successCount.addAndGet(tcpStats.successCount.get() * (long)sign);
        this.timeoutCount.addAndGet(tcpStats.timeoutCount.get() * (long)sign);
    }

    public Map<String, Object> toStatMap() {
        HashMap<String, Object> statsMap = new HashMap<String, Object>();
        statsMap.put("totalSize", this.getTotalSize());
        statsMap.put("tcpLoss", this.getTcpLoss());
        statsMap.put("lossInNet", this.getLossInNet());
        statsMap.put("lossSize", this.getLossSize());
        statsMap.put("tcpPollCount", this.getTcpPollCount());
        statsMap.put("successCount", this.getSuccessCount());
        statsMap.put("timeoutCount", this.getTimeoutCount());
        return statsMap;
    }

    public String toString() {
        return "TCPStats{totalSize=" + this.totalSize + ", tcpLoss=" + this.tcpLoss + ", lossInNet=" + this.lossInNet + ", lossSize=" + this.lossSize + ", tcpPollCount=" + this.tcpPollCount + ", successCount=" + this.successCount + ", timeoutCount=" + this.timeoutCount + '}';
    }
}

