/*
 * Decompiled with CFR 0.152.
 */
package io.etrace.agent.stat;

import io.etrace.agent.stat.TCPStats;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

public class MetricStats {
    private AtomicLong totalCount = new AtomicLong(0L);
    private AtomicLong loss = new AtomicLong(0L);
    private AtomicLong packageLoss = new AtomicLong(0L);
    private AtomicLong merge = new AtomicLong(0L);
    private AtomicLong mergeAfterTotal = new AtomicLong(0L);
    private TCPStats tcpStats;
    private MetricStats history;

    public MetricStats() {
        this.tcpStats = new TCPStats();
    }

    public MetricStats(TCPStats tcpStats) {
        this.tcpStats = tcpStats;
    }

    public void incMergeAfterTotal(long count) {
        this.mergeAfterTotal.addAndGet(count);
    }

    public void incTotalCount() {
        this.totalCount.addAndGet(1L);
    }

    public void incLoss() {
        this.loss.addAndGet(1L);
    }

    public void incPackageLoss(int count) {
        this.packageLoss.addAndGet(count);
    }

    public void incMerge(int count) {
        this.merge.addAndGet(count);
    }

    public long getTotalCount() {
        return this.totalCount.get();
    }

    public void setTotalCount(long totalCount) {
        this.totalCount.addAndGet(totalCount);
    }

    public long getLoss() {
        return this.loss.get();
    }

    public void setLoss(long loss) {
        this.loss.addAndGet(loss);
    }

    public long getMerge() {
        return this.merge.get();
    }

    public void setMerge(long merge) {
        this.merge.addAndGet(merge);
    }

    public long getMergeAfterTotal() {
        return this.mergeAfterTotal.get();
    }

    public long getPackageLoss() {
        return this.packageLoss.get();
    }

    public TCPStats getTcpStats() {
        return this.tcpStats;
    }

    public MetricStats getHistory() {
        if (this.history == null) {
            this.history = new MetricStats();
        }
        return this.history;
    }

    public Map<String, Object> toStatMap() {
        HashMap<String, Object> statsMap = new HashMap<String, Object>();
        statsMap.put("totalCount", this.getTotalCount());
        statsMap.put("loss", this.getLoss());
        statsMap.put("packageLoss", this.getPackageLoss());
        statsMap.put("merge", this.getMerge());
        statsMap.put("mergeAfterTotal", this.getMergeAfterTotal());
        statsMap.putAll(this.tcpStats.toStatMap());
        return statsMap;
    }

    public MetricStats copyStats() {
        TCPStats newTCPStats = this.tcpStats.copyStats();
        MetricStats newStats = new MetricStats(newTCPStats);
        newStats.loss.addAndGet(this.getLoss());
        newStats.totalCount.addAndGet(this.getTotalCount());
        newStats.packageLoss.addAndGet(this.getPackageLoss());
        newStats.merge.addAndGet(this.getMerge());
        newStats.mergeAfterTotal.addAndGet(this.getMergeAfterTotal());
        return newStats;
    }

    public void resetToHistory(MetricStats resetStats) {
        this.loss.addAndGet(-resetStats.getLoss());
        this.totalCount.addAndGet(-resetStats.getTotalCount());
        this.packageLoss.addAndGet(-resetStats.getPackageLoss());
        this.merge.addAndGet(-resetStats.getMerge());
        this.mergeAfterTotal.addAndGet(-resetStats.getMergeAfterTotal());
        this.tcpStats.decrement(resetStats.tcpStats);
        this.getHistory().loss.addAndGet(resetStats.getLoss());
        this.getHistory().totalCount.addAndGet(resetStats.getTotalCount());
        this.getHistory().packageLoss.addAndGet(resetStats.getPackageLoss());
        this.getHistory().merge.addAndGet(resetStats.getMerge());
        this.getHistory().mergeAfterTotal.addAndGet(resetStats.getMergeAfterTotal());
        this.getHistory().tcpStats.inc(resetStats.tcpStats);
    }

    public String toString() {
        return "MetricStats{totalCount=" + this.totalCount + ", loss=" + this.loss + ", packageLoss=" + this.packageLoss + ", merge=" + this.merge + ", mergeAfterTotal=" + this.mergeAfterTotal + ", tcpStats=" + this.tcpStats + ", history=" + this.history + '}';
    }
}

