/*
 * Decompiled with CFR 0.152.
 */
package io.etrace.agent.stat;

import java.util.concurrent.atomic.AtomicLong;

public class HeartbeatStats {
    private AtomicLong totalSize = new AtomicLong(0L);
    private AtomicLong totalCount = new AtomicLong(0L);
    private AtomicLong successCount = new AtomicLong(0L);

    public void incTotalSize(long totalSize) {
        this.totalSize.set(totalSize);
    }

    public void incTotalCount(long totalCount) {
        this.totalCount.set(totalCount);
    }

    public void incSuccessCount(long successCount) {
        this.successCount.set(successCount);
    }

    public long getTotalSize() {
        return this.totalSize.get();
    }

    public long getTotalCount() {
        return this.totalCount.get();
    }

    public long getSuccessCount() {
        return this.successCount.get();
    }

    public HeartbeatStats copyStats() {
        HeartbeatStats newHeartbeatStats = new HeartbeatStats();
        newHeartbeatStats.incTotalSize(this.totalSize.get());
        newHeartbeatStats.incTotalCount(this.totalCount.get());
        newHeartbeatStats.incSuccessCount(this.successCount.get());
        return newHeartbeatStats;
    }

    public void decrement(HeartbeatStats heartbeatStats) {
        this.update(heartbeatStats, -1);
    }

    public void inc(HeartbeatStats heartbeatStats) {
        this.update(heartbeatStats, 1);
    }

    private void update(HeartbeatStats heartbeatStats, int sign) {
        this.totalSize.addAndGet(heartbeatStats.totalSize.get() * (long)sign);
        this.totalCount.addAndGet(heartbeatStats.totalCount.get() * (long)sign);
        this.successCount.addAndGet(heartbeatStats.successCount.get() * (long)sign);
    }

    public String toString() {
        return "HeartbeatStats{totalSize=" + this.totalSize + ", totalCount=" + this.totalCount + ", successCount=" + this.successCount + '}';
    }
}

