/*
 * Decompiled with CFR 0.152.
 */
package io.etrace.agent.stat;

import io.etrace.agent.stat.HeartbeatStats;
import io.etrace.agent.stat.TCPStats;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

public class CallstackStats {
    private AtomicLong totalCount = new AtomicLong(0L);
    private AtomicLong loss = new AtomicLong(0L);
    private TCPStats tcpStats;
    private HeartbeatStats heartbeatStats;
    private CallstackStats history;

    public CallstackStats(TCPStats tcpStats, HeartbeatStats heartbeatStats) {
        this.tcpStats = tcpStats;
        this.heartbeatStats = heartbeatStats;
    }

    public CallstackStats() {
        this.tcpStats = new TCPStats();
        this.heartbeatStats = new HeartbeatStats();
    }

    public TCPStats getTcpStats() {
        return this.tcpStats;
    }

    public void incTotalCount() {
        this.totalCount.addAndGet(1L);
    }

    public void incLoss() {
        this.loss.addAndGet(1L);
    }

    public void incLoss(int loss) {
        this.loss.addAndGet(loss);
    }

    public long getTotalCount() {
        return this.totalCount.get();
    }

    public void setTotalCount(long totalCount) {
        this.totalCount.set(totalCount);
    }

    public long getLoss() {
        return this.loss.get();
    }

    public void setLoss(long loss) {
        this.loss.set(loss);
    }

    public HeartbeatStats getHeartbeatStats() {
        return this.heartbeatStats;
    }

    public CallstackStats getHistory() {
        if (this.history == null) {
            this.history = new CallstackStats();
        }
        return this.history;
    }

    public CallstackStats copyStats() {
        TCPStats newTCPStats = this.tcpStats.copyStats();
        HeartbeatStats newHeartbeatStats = this.heartbeatStats.copyStats();
        CallstackStats newStats = new CallstackStats(newTCPStats, newHeartbeatStats);
        newStats.setLoss(this.getLoss());
        newStats.setTotalCount(this.getTotalCount());
        return newStats;
    }

    public Map<String, Object> toStatMap() {
        HashMap<String, Object> statsMap = new HashMap<String, Object>();
        statsMap.put("lossSize", this.tcpStats.getLossSize());
        statsMap.put("loss", this.getLoss() + this.tcpStats.getTcpLoss());
        statsMap.put("lossInNet", this.tcpStats.getLossInNet());
        statsMap.put("totalSize", this.tcpStats.getTotalSize() + this.heartbeatStats.getTotalSize());
        statsMap.put("totalCount", this.getTotalCount() + this.heartbeatStats.getTotalCount());
        statsMap.put("successCount", this.tcpStats.getSuccessCount() + this.heartbeatStats.getSuccessCount());
        statsMap.put("tcpPollCount", this.tcpStats.getTcpPollCount());
        return statsMap;
    }

    public void resetToHistory(CallstackStats resetStats) {
        this.loss.addAndGet(-resetStats.getLoss());
        this.totalCount.addAndGet(-resetStats.getTotalCount());
        this.tcpStats.decrement(resetStats.tcpStats);
        this.heartbeatStats.decrement(resetStats.heartbeatStats);
        this.getHistory().tcpStats.inc(resetStats.tcpStats);
        this.getHistory().loss.addAndGet(resetStats.getLoss());
        this.getHistory().totalCount.addAndGet(resetStats.getTotalCount());
        this.getHistory().heartbeatStats.inc(resetStats.heartbeatStats);
    }

    public String toString() {
        return "CallstackStats{totalCount=" + this.totalCount + ", loss=" + this.loss + ", tcpStats=" + this.tcpStats + ", heartbeatStats=" + this.heartbeatStats + ", history=" + this.history + '}';
    }
}

