/*
 * Decompiled with CFR 0.152.
 */
package io.etrace.agent.network;

import io.etrace.agent.config.CollectorRegistry;
import io.etrace.agent.network.AbstractConnection;
import io.etrace.common.modal.Collector;
import io.etrace.common.rpc.MessageService;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TFramedTransport;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;

public class ThriftConnection
extends AbstractConnection {
    private TFramedTransport transport;
    private TSocket socket;
    private TBinaryProtocol protocol;
    private MessageService.Client collector;
    private Collector currentCollector;

    public ThriftConnection(int senderTimeout) {
        super(senderTimeout);
    }

    @Override
    public void openConnection() {
        int collectorSize = CollectorRegistry.getInstance().getCollectorSize();
        if (collectorSize < 1) {
            System.out.println("Etrace-Agent: no Available Collectors, Can't open Thrift Connection. Check ConfigManager for collector address api.");
            return;
        }
        for (int i = 0; i < collectorSize; ++i) {
            try {
                this.currentCollector = CollectorRegistry.getInstance().getThriftCollector();
                if (this.currentCollector == null) {
                    return;
                }
                this.socket = new TSocket(this.currentCollector.getIp(), this.currentCollector.getPort());
                this.socket.setTimeout(this.timeout);
                this.transport = new TFramedTransport((TTransport)this.socket);
                this.protocol = new TBinaryProtocol((TTransport)this.transport);
                this.collector = new MessageService.Client((TProtocol)this.protocol);
                this.transport.open();
                return;
            }
            catch (Throwable ignore) {
                this.closeConnection();
                continue;
            }
        }
    }

    @Override
    public boolean isOpen() {
        return this.transport != null && this.transport.isOpen() && this.socket != null && this.socket.isOpen() && this.protocol != null && this.collector != null;
    }

    @Override
    public void closeConnection() {
        if (this.transport != null && this.transport.isOpen()) {
            try {
                this.transport.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.transport = null;
        }
        if (this.socket != null && this.socket.isOpen()) {
            try {
                this.socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.socket = null;
        }
        if (this.protocol != null) {
            this.protocol = null;
        }
        if (this.collector != null) {
            this.collector = null;
        }
        this.currentCollector = null;
    }

    @Override
    public Object getSocketClient() {
        return this.collector;
    }
}

