/*
 * Decompiled with CFR 0.152.
 */
package io.etrace.agent.network;

import io.etrace.agent.config.CollectorRegistry;
import io.etrace.agent.network.AbstractConnection;
import io.etrace.common.modal.Collector;
import java.net.InetSocketAddress;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;

public class TcpConnection
extends AbstractConnection {
    private Selector selector;
    private SocketChannel socketChannel;
    private Collector currentCollector;

    public TcpConnection(int senderTimeout) {
        super(senderTimeout);
    }

    @Override
    public void openConnection() {
        int collectorSize = CollectorRegistry.getInstance().getTcpCollectorSize();
        if (collectorSize < 1) {
            return;
        }
        for (int i = 0; i < collectorSize; ++i) {
            try {
                this.currentCollector = CollectorRegistry.getInstance().getTcpCollector();
                if (this.currentCollector == null) {
                    return;
                }
                this.selector = Selector.open();
                this.socketChannel = SocketChannel.open();
                this.socketChannel.configureBlocking(true);
                this.socketChannel.socket().setTcpNoDelay(true);
                this.socketChannel.socket().setKeepAlive(true);
                this.socketChannel.socket().setSoTimeout(this.timeout);
                this.socketChannel.socket().connect(new InetSocketAddress(this.currentCollector.getIp(), this.currentCollector.getPort()), this.timeout);
                return;
            }
            catch (Throwable ignore) {
                this.closeConnection();
                continue;
            }
        }
    }

    @Override
    public boolean isOpen() {
        return null != this.selector && this.selector.isOpen() && null != this.socketChannel && this.socketChannel.isConnected() && this.socketChannel.isOpen();
    }

    @Override
    public void closeConnection() {
        try {
            if (null != this.socketChannel) {
                this.socketChannel.socket().close();
                this.socketChannel.close();
                this.socketChannel = null;
            }
            if (null != this.selector) {
                this.selector.close();
                if (null != this.selector) {
                    this.selector.wakeup();
                    this.selector = null;
                }
            }
        }
        catch (Exception e) {
            this.socketChannel = null;
            this.selector = null;
        }
        this.currentCollector = null;
    }

    @Override
    public Object getSocketClient() {
        return this.socketChannel;
    }
}

