/*
 * Decompiled with CFR 0.152.
 */
package io.etrace.agent.network;

import io.etrace.agent.config.CollectorRegistry;
import io.etrace.agent.network.AbstractConnection;
import io.etrace.agent.network.Connection;
import io.etrace.agent.network.SocketClient;
import io.etrace.agent.network.TcpConnection;
import io.etrace.agent.network.ThriftConnection;

public abstract class AbstractSocketClient
implements SocketClient {
    private static final long LONG_TIME_CLOSE = 330000L;
    protected Connection connection;
    protected boolean useTcp;
    private long lastVisitTime = System.currentTimeMillis();
    private int SENDER_TIMEOUT;

    public AbstractSocketClient(int senderTimeout) {
        this.SENDER_TIMEOUT = senderTimeout;
    }

    protected void getConnection() {
        this.useTcp = CollectorRegistry.getInstance().isUseTcp();
        if (this.connection == null || !this.connection.isOpen()) {
            this.closeConnection();
            AbstractConnection newConnect = this.useTcp ? new TcpConnection(this.SENDER_TIMEOUT) : new ThriftConnection(this.SENDER_TIMEOUT);
            newConnect.openConnection();
            this.connection = newConnect;
        } else {
            if (this.useTcp) {
                if (this.connection instanceof ThriftConnection) {
                    this.closeConnection();
                    TcpConnection newConnect = new TcpConnection(this.SENDER_TIMEOUT);
                    newConnect.openConnection();
                    this.connection = newConnect;
                }
            } else if (this.connection instanceof TcpConnection) {
                this.closeConnection();
                ThriftConnection newConnect = new ThriftConnection(this.SENDER_TIMEOUT);
                newConnect.openConnection();
                this.connection = newConnect;
            }
            if (!this.connection.isOpen()) {
                this.connection.openConnection();
            }
        }
    }

    @Override
    public boolean send(byte[] head, byte[] chunk) {
        return this.sendTryTwice(head, chunk);
    }

    private boolean sendTryTwice(byte[] head, byte[] chunk) {
        for (int action = 0; action < 2; ++action) {
            if (!this.send0(head, chunk)) continue;
            return true;
        }
        return false;
    }

    public abstract boolean send0(byte[] var1, byte[] var2);

    @Override
    public void tryCloseConnWhenLongTime() {
        if (System.currentTimeMillis() - this.lastVisitTime > 330000L && this.connection != null && this.connection.isOpen()) {
            this.connection.closeConnection();
            this.lastVisitTime = System.currentTimeMillis();
        }
    }

    protected boolean isOpen() {
        return this.connection != null && this.connection.isOpen();
    }

    public void closeConnection() {
        if (this.connection != null) {
            this.connection.closeConnection();
        }
    }

    @Override
    public void shutdown() {
        this.closeConnection();
    }
}

