/*
 * Decompiled with CFR 0.152.
 */
package io.etrace.agent.monitor.mbean;

import io.etrace.agent.config.AgentConfiguration;
import io.etrace.common.modal.Pair;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public class MBeanExecutor {
    public Map<String, List<Pair<String, String>>> execute() {
        LinkedHashMap<String, List<Pair<String, String>>> m = null;
        try {
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            Set<String> objectNames = AgentConfiguration.getBeanObjectNames();
            if (objectNames == null) {
                return null;
            }
            for (String objectName : objectNames) {
                try {
                    List<Pair<String, String>> attrs = this.getAttrs(mBeanServer, objectName);
                    if (attrs == null || attrs.isEmpty()) continue;
                    if (m == null) {
                        m = new LinkedHashMap<String, List<Pair<String, String>>>();
                    }
                    m.put(objectName, attrs);
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return m;
    }

    private List<Pair<String, String>> getAttrs(MBeanServer mBeanServer, String objectName) throws MalformedObjectNameException, IntrospectionException, InstanceNotFoundException, ReflectionException {
        ObjectName on = new ObjectName(objectName);
        MBeanInfo mBeanInfo = mBeanServer.getMBeanInfo(on);
        if (mBeanInfo == null) {
            return null;
        }
        MBeanAttributeInfo[] attributeInfos = mBeanInfo.getAttributes();
        if (attributeInfos == null) {
            return null;
        }
        ArrayList<Pair<String, String>> attrs = new ArrayList<Pair<String, String>>();
        for (MBeanAttributeInfo mat : attributeInfos) {
            try {
                Object attrValue = mBeanServer.getAttribute(on, mat.getName());
                if (attrValue == null) continue;
                attrs.add((Pair<String, String>)new Pair((Object)mat.getName(), (Object)String.valueOf(attrValue)));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return attrs;
    }

    public boolean needMBean() {
        Set<String> objectNames = AgentConfiguration.getBeanObjectNames();
        return objectNames != null && !objectNames.isEmpty();
    }
}

