/*
 * Decompiled with CFR 0.152.
 */
package io.etrace.agent.monitor.jvm;

import io.etrace.agent.monitor.HeartBeatExecutor;
import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.LinkedHashMap;
import java.util.Map;

public class JvmThreadHeartBeatExecutor
extends HeartBeatExecutor {
    private static final int MAX_FRAMES = 20;
    private boolean dumpLocked;

    public JvmThreadHeartBeatExecutor(String type) {
        super(type);
    }

    public void setDumpLocked(boolean dumpLocked) {
        this.dumpLocked = dumpLocked;
    }

    @Override
    public Map<String, String> execute() {
        LinkedHashMap<String, String> jvmThreadInfoMap = new LinkedHashMap<String, String>();
        ThreadMXBean bean = ManagementFactory.getThreadMXBean();
        bean.setThreadContentionMonitoringEnabled(true);
        ThreadInfo[] threads = bean.dumpAllThreads(this.dumpLocked, this.dumpLocked);
        this.putAttrToMap(jvmThreadInfoMap, this.type, "threadInfos", this.getJvmThreadInfos(threads));
        return jvmThreadInfoMap;
    }

    private String getJvmThreadInfos(ThreadInfo[] threads) {
        StringBuilder threadInfosBuilder = new StringBuilder();
        for (ThreadInfo threadInfo : threads) {
            this.putJvmThreadInfo(threadInfosBuilder, threadInfo);
        }
        return threadInfosBuilder.toString();
    }

    private void putJvmThreadInfo(StringBuilder threadInfosBuilder, ThreadInfo threadInfo) {
        threadInfosBuilder.append(this.toString(threadInfo));
    }

    private JvmThreadHeartBeatExecutor putAttrToMap(Map<String, String> m, String type, String subType, Object value) {
        m.put(String.format("%s%s%s", type, ".", subType), String.valueOf(value));
        return this;
    }

    public String toString(ThreadInfo threadInfo) {
        LockInfo[] locks;
        int i;
        StringBuilder sb = new StringBuilder("\"");
        sb.append(threadInfo.getThreadName());
        sb.append("\"");
        sb.append(" Id=");
        sb.append(threadInfo.getThreadId());
        sb.append(" ");
        sb.append((Object)threadInfo.getThreadState());
        if (threadInfo.getLockName() != null) {
            sb.append(" on ");
            sb.append(threadInfo.getLockName());
        }
        if (threadInfo.getLockOwnerName() != null) {
            sb.append(" owned by \"");
            sb.append(threadInfo.getLockOwnerName());
            sb.append("\" Id=");
            sb.append(threadInfo.getLockOwnerId());
        }
        if (threadInfo.isSuspended()) {
            sb.append(" (suspended)");
        }
        if (threadInfo.isInNative()) {
            sb.append(" (in native)");
        }
        sb.append(" (BlockedTime=");
        sb.append(threadInfo.getBlockedTime());
        sb.append(", BlockedCount=");
        sb.append(threadInfo.getBlockedCount());
        sb.append(", WaitedTime=");
        sb.append(threadInfo.getWaitedTime());
        sb.append(", WaitedCount=");
        sb.append(threadInfo.getWaitedCount());
        sb.append(")");
        sb.append('\n');
        StackTraceElement[] stackTrace = threadInfo.getStackTrace();
        for (i = 0; i < stackTrace.length && i < 20; ++i) {
            MonitorInfo[] lockedMonitors;
            StackTraceElement ste = stackTrace[i];
            sb.append("\tat ");
            sb.append(ste.toString());
            sb.append('\n');
            if (i == 0 && threadInfo.getLockInfo() != null) {
                Thread.State ts = threadInfo.getThreadState();
                switch (ts) {
                    case BLOCKED: {
                        sb.append("\t-  blocked on ");
                        sb.append(threadInfo.getLockInfo());
                        sb.append('\n');
                        break;
                    }
                    case WAITING: {
                        sb.append("\t-  waiting on ");
                        sb.append(threadInfo.getLockInfo());
                        sb.append('\n');
                        break;
                    }
                    case TIMED_WAITING: {
                        sb.append("\t-  waiting on ");
                        sb.append(threadInfo.getLockInfo());
                        sb.append('\n');
                        break;
                    }
                }
            }
            MonitorInfo[] monitorInfoArray = lockedMonitors = threadInfo.getLockedMonitors();
            int n = monitorInfoArray.length;
            for (int j = 0; j < n; ++j) {
                MonitorInfo mi = monitorInfoArray[j];
                if (mi.getLockedStackDepth() != i) continue;
                sb.append("\t-  locked ");
                sb.append(mi);
                sb.append('\n');
            }
        }
        if (i < stackTrace.length) {
            sb.append("\t...");
            sb.append('\n');
        }
        if ((locks = threadInfo.getLockedSynchronizers()).length > 0) {
            sb.append("\n\tNumber of locked synchronizers = ");
            sb.append(locks.length);
            sb.append('\n');
            for (LockInfo li : locks) {
                sb.append("\t- ");
                sb.append(li);
                sb.append('\n');
            }
        }
        sb.append('\n');
        return sb.toString();
    }
}

