/*
 * Decompiled with CFR 0.152.
 */
package io.etrace.agent.monitor.jvm;

import io.etrace.agent.monitor.HeartBeatExecutor;
import io.etrace.agent.monitor.SunManagementBean;
import io.etrace.agent.monitor.jvm.GarbageInfo;
import io.etrace.agent.monitor.jvm.JvmMetric;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.ThreadMXBean;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JvmHeartBeatExecutor
extends HeartBeatExecutor {
    private Map<String, GarbageInfo> garbageInfos = new HashMap<String, GarbageInfo>();
    private SunManagementBean sunManagementBean = SunManagementBean.getBean();

    public JvmHeartBeatExecutor(String type) {
        super(type);
    }

    @Override
    public Map<String, String> execute() {
        JvmMetric jvmMetric = new JvmMetric(this.type);
        this.buildGarbageMetrics(jvmMetric);
        this.buildMemoryMetrics(jvmMetric);
        this.buildMemoryPoolMetrics(jvmMetric);
        this.buildThreadSizeMetrics(jvmMetric);
        this.buildClassLoadMetrics(jvmMetric);
        this.buildCpuMetrics(jvmMetric);
        return jvmMetric.getMetrics();
    }

    private void buildGarbageMetrics(JvmMetric metrics) {
        for (GarbageCollectorMXBean mbean : ManagementFactory.getGarbageCollectorMXBeans()) {
            long gcTime;
            GarbageInfo garbageInfo = this.getGarbageInfo(mbean.getName());
            long gcCount = mbean.getCollectionCount();
            if (gcCount > 0L) {
                metrics.put(garbageInfo.getGcCountKey(), garbageInfo.getGcCount(gcCount));
            }
            if ((gcTime = mbean.getCollectionTime()) <= 0L) continue;
            metrics.put(garbageInfo.getGcTimeKey(), garbageInfo.getGcTime(gcTime));
        }
    }

    private GarbageInfo getGarbageInfo(String garbageName) {
        GarbageInfo garbageInfo = this.garbageInfos.get(garbageName);
        if (null == garbageInfo) {
            garbageInfo = new GarbageInfo(this.type, garbageName);
            this.garbageInfos.put(garbageName, garbageInfo);
        }
        return garbageInfo;
    }

    private void buildMemoryMetrics(JvmMetric metrics) {
        MemoryMXBean memoryBean = ManagementFactory.getMemoryMXBean();
        metrics.put(JvmMetric.MetricType.MEMORY_HEAPUSED, memoryBean.getHeapMemoryUsage().getUsed());
        metrics.put(JvmMetric.MetricType.MEMORY_HEAPMAX, memoryBean.getHeapMemoryUsage().getMax());
        metrics.put(JvmMetric.MetricType.MEMORY_NONHEAPUSED, memoryBean.getNonHeapMemoryUsage().getUsed());
    }

    private void buildMemoryPoolMetrics(JvmMetric metrics) {
        List<MemoryPoolMXBean> memoryPoolMXBeans = ManagementFactory.getMemoryPoolMXBeans();
        for (MemoryPoolMXBean memoryPoolMXBean : memoryPoolMXBeans) {
            String name = memoryPoolMXBean.getName();
            MemoryUsage usage = memoryPoolMXBean.getUsage();
            metrics.put(JvmMetric.MetricType.MEMORY_POOL, name, "init", usage.getInit());
            metrics.put(JvmMetric.MetricType.MEMORY_POOL, name, "used", usage.getUsed());
            metrics.put(JvmMetric.MetricType.MEMORY_POOL, name, "committed", usage.getCommitted());
            metrics.put(JvmMetric.MetricType.MEMORY_POOL, name, "max", usage.getMax());
        }
    }

    public void buildThreadSizeMetrics(JvmMetric metrics) {
        ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();
        metrics.put(JvmMetric.MetricType.THREAD_THREADS, (long)threadBean.getThreadCount());
        metrics.put(JvmMetric.MetricType.THREAD_DAEMON, (long)threadBean.getDaemonThreadCount());
        long[] deadlockedThreads = threadBean.findDeadlockedThreads();
        metrics.put(JvmMetric.MetricType.THREAD_DEADLOCKED, deadlockedThreads != null ? (long)deadlockedThreads.length : 0L);
    }

    public void buildClassLoadMetrics(JvmMetric metrics) {
        metrics.put(JvmMetric.MetricType.LOADED_CLASSES, (long)ManagementFactory.getClassLoadingMXBean().getLoadedClassCount());
    }

    private void buildCpuMetrics(JvmMetric metrics) {
        metrics.put(JvmMetric.MetricType.CPU_USAGE, this.sunManagementBean.getProcessCpuLoad());
    }
}

