/*
 * Decompiled with CFR 0.152.
 */
package io.etrace.agent.monitor.jvm;

import io.etrace.agent.monitor.jvm.JvmMetric;

public class GarbageInfo {
    private final String gcCountKey;
    private final String gcTimeKey;
    private long gcCount = -1L;
    private long gcTime = -1L;

    public GarbageInfo(String type, String garbageName) {
        this.gcCountKey = type + "." + JvmMetric.MetricType.GARBAGE_COUNT.toString().replace("_", ".").toLowerCase() + "." + garbageName;
        this.gcTimeKey = type + "." + JvmMetric.MetricType.GARBAGE_TIME.toString().replace("_", ".").toLowerCase() + "." + garbageName;
    }

    public String getGcCountKey() {
        return this.gcCountKey;
    }

    public String getGcTimeKey() {
        return this.gcTimeKey;
    }

    public long getGcCount(long gcCount) {
        long count = this.gcCount > 0L ? gcCount - this.gcCount : gcCount;
        this.gcCount = gcCount;
        return count;
    }

    public long getGcTime(long gcTime) {
        long time = this.gcTime > 0L ? gcTime - this.gcTime : gcTime;
        this.gcTime = gcTime;
        return time;
    }
}

