/*
 * Decompiled with CFR 0.152.
 */
package io.etrace.agent.monitor;

import java.lang.management.ManagementFactory;

public class SunManagementBean {
    private static SunManagementBean jvmSunManagementBean = new SunManagementBean();
    private OperatingSystemMXBean operatingSystemMXBean;

    private SunManagementBean() {
        try {
            Class.forName("com.sun.management.OperatingSystemMXBean");
        }
        catch (ClassNotFoundException e) {
            return;
        }
        this.operatingSystemMXBean = new OperatingSystemMXBean();
        this.operatingSystemMXBean.getProcessCpuLoad();
    }

    public static SunManagementBean getBean() {
        return jvmSunManagementBean;
    }

    public double getProcessCpuLoad() {
        if (this.operatingSystemMXBean == null) {
            return -1.0;
        }
        return this.operatingSystemMXBean.getProcessCpuLoad() * 100.0;
    }

    public double getSystemMemorySize() {
        if (this.operatingSystemMXBean == null) {
            return -1.0;
        }
        return this.operatingSystemMXBean.getTotalPhysicalMemorySize();
    }

    private class OperatingSystemMXBean {
        com.sun.management.OperatingSystemMXBean sunOperatingSystemMXBean = ManagementFactory.getPlatformMXBean(com.sun.management.OperatingSystemMXBean.class);

        private OperatingSystemMXBean() {
        }

        private double getProcessCpuLoad() {
            return this.sunOperatingSystemMXBean.getProcessCpuLoad();
        }

        private double getTotalPhysicalMemorySize() {
            return this.sunOperatingSystemMXBean.getTotalPhysicalMemorySize();
        }
    }
}

