/*
 * Decompiled with CFR 0.152.
 */
package io.etrace.agent.monitor;

import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.inject.Inject;
import io.etrace.agent.Trace;
import io.etrace.agent.config.AgentConfiguration;
import io.etrace.agent.message.callstack.CallstackProducer;
import io.etrace.agent.message.heartbeat.HeartbeatQueue;
import io.etrace.agent.monitor.HeartBeatExecutor;
import io.etrace.agent.monitor.jvm.EnvironmentExecutor;
import io.etrace.agent.monitor.jvm.JvmHeartBeatExecutor;
import io.etrace.agent.monitor.jvm.JvmThreadHeartBeatExecutor;
import io.etrace.agent.monitor.mbean.MBeanExecutor;
import io.etrace.agent.stat.CallstackStats;
import io.etrace.agent.stat.HeartbeatStats;
import io.etrace.agent.stat.MetricStats;
import io.etrace.common.message.MessageManager;
import io.etrace.common.modal.Event;
import io.etrace.common.modal.Heartbeat;
import io.etrace.common.modal.Message;
import io.etrace.common.modal.Pair;
import io.etrace.common.modal.Transaction;
import io.etrace.common.modal.impl.TransactionImpl;
import io.etrace.common.util.JSONUtil;
import io.etrace.common.util.NetworkInterfaceHelper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class HeartbeatUploadTask {
    private String INIT = "Init";
    private String INTERNAL_SEND = "Send_to_collector";
    private String CALLSTACK_TO_JSON = "CallStack_to_json";
    private String CLOSE_GENERATOR = "Close_generator";
    private String LOG_ENVIRONMENT = "Environment";
    private String LOG_EXECUTOR = "Executors";
    private String LOG_THREAD_EXECUTOR = "Thread-dump";
    private String LOG_MBEAN_EXECUTOR = "Mbean";
    private final String HOST_IP = NetworkInterfaceHelper.INSTANCE.getLocalHostAddress();
    private final Map<String, String> monitorErrorInfo = new HashMap<String, String>();
    @Inject
    MessageManager messageManager;
    private List<HeartBeatExecutor> heartBeatExecutors;
    @Inject
    private CallstackStats callstackStats;
    @Inject
    private MetricStats metricStats;
    private HeartbeatStats heartbeatStats;
    @Inject
    private CallstackProducer producer;
    @Inject
    private HeartbeatQueue heartbeatQueue;
    private JvmThreadHeartBeatExecutor jvmThreadExecutor;
    private EnvironmentExecutor environmentExecutor;
    private MBeanExecutor mBeanExecutor;
    private ScheduledExecutorService executorService;
    private Long heartbeatDelay = 10L;
    private Long heartbeatInterval = 60L;
    private int count = 0;
    private boolean rebootEventSent = false;

    public HeartbeatUploadTask(Long heartbeatDelayInSecond, Long heartbeatIntervalInSecond) {
        this.heartbeatDelay = heartbeatDelayInSecond;
        this.heartbeatInterval = heartbeatIntervalInSecond;
    }

    public HeartbeatUploadTask() {
    }

    public void startup() {
        this.initExecutors();
        this.executorService = new ScheduledThreadPoolExecutor(1, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("HeartbeatUploadTask").build());
        this.executorService.scheduleAtFixedRate(this::uploadStat, this.heartbeatDelay, this.heartbeatInterval, TimeUnit.SECONDS);
    }

    private void logRebootEvent() {
        Event event = Trace.newEvent("Reboot", this.HOST_IP);
        event.setStatus("0");
        this.internalSend((Message)event);
    }

    private void initExecutors() {
        this.heartbeatStats = this.callstackStats.getHeartbeatStats();
        try {
            this.jvmThreadExecutor = new JvmThreadHeartBeatExecutor("jvmThread");
            this.environmentExecutor = new EnvironmentExecutor("environment");
            this.heartBeatExecutors = Lists.newArrayList((Object[])new HeartBeatExecutor[]{new JvmHeartBeatExecutor("jvm")});
            this.mBeanExecutor = new MBeanExecutor();
        }
        catch (Exception ignore) {
            this.monitorErrorInfo.put(this.INIT, ignore.getMessage());
        }
    }

    public void shutdown() {
        this.executorService.shutdown();
    }

    private void uploadStat() {
        if (!this.rebootEventSent) {
            this.logRebootEvent();
            this.rebootEventSent = true;
        }
        if (this.count % 60 == 0) {
            this.logEnvironment();
            this.count = 0;
        }
        this.logMBeanInfo();
        this.logStatus();
        ++this.count;
    }

    public void logEnvironment() {
        Heartbeat h = this.producer.newHeartbeat("Environment", this.HOST_IP);
        try {
            Map<String, String> values = this.environmentExecutor.execute();
            if (values != null && values.size() > 0) {
                h.addTags(values);
            }
            h.setStatus("0");
        }
        catch (Throwable e) {
            this.monitorErrorInfo.put(this.LOG_ENVIRONMENT, e.getMessage());
            h.setStatus(e);
        }
        finally {
            this.internalSend((Message)h);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logStatus() {
        long step1 = System.currentTimeMillis();
        Transaction statusTransaction = Trace.newTransaction("System", "Status");
        try {
            this.logExecutor();
            statusTransaction.setStatus("0");
        }
        finally {
            statusTransaction.setDuration(System.currentTimeMillis() - step1);
            this.internalSend((Message)statusTransaction);
        }
        long step2 = System.currentTimeMillis();
        Transaction threadDumpTransaction = Trace.newTransaction("System", "Thread-Dump");
        if (threadDumpTransaction instanceof TransactionImpl) {
            ((TransactionImpl)threadDumpTransaction).setTimestamp(statusTransaction.getTimestamp());
        }
        CallstackStats nowStats = this.callstackStats.copyStats();
        MetricStats nowMetricStats = this.metricStats.copyStats();
        try {
            this.logThreadExecutor();
            this.logMessageStats(nowStats, nowMetricStats);
            threadDumpTransaction.setStatus("0");
        }
        finally {
            threadDumpTransaction.setDuration(System.currentTimeMillis() - step2);
            boolean success = this.internalSend((Message)threadDumpTransaction);
            if (success) {
                this.monitorErrorInfo.clear();
                this.metricStats.resetToHistory(nowMetricStats);
                this.callstackStats.resetToHistory(nowStats);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logMBeanInfo() {
        long start = System.currentTimeMillis();
        if (!this.mBeanExecutor.needMBean()) {
            return;
        }
        Map<String, List<Pair<String, String>>> mbeanInfos = this.mBeanExecutor.execute();
        if (mbeanInfos == null || mbeanInfos.isEmpty()) {
            return;
        }
        Transaction t = Trace.newTransaction("Platform", "MBean");
        try {
            mbeanInfos.forEach(this::mbeanInfo);
            t.setStatus("0");
        }
        catch (Throwable e) {
            this.monitorErrorInfo.put(this.LOG_MBEAN_EXECUTOR, e.getMessage());
        }
        finally {
            t.setDuration(System.currentTimeMillis() - start);
            this.internalSend((Message)t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logExecutor() {
        Heartbeat h = this.producer.newHeartbeat("Heartbeat", this.HOST_IP);
        try {
            for (HeartBeatExecutor heartBeatExecutor : this.heartBeatExecutors) {
                try {
                    Map<String, String> values = heartBeatExecutor.execute();
                    if (values == null || values.size() <= 0) continue;
                    h.addTags(values);
                }
                catch (Exception e) {
                    this.monitorErrorInfo.put(heartBeatExecutor.type, e.getMessage());
                }
            }
            h.setStatus("0");
        }
        catch (Throwable e) {
            this.monitorErrorInfo.put(this.LOG_EXECUTOR, e.getMessage());
            h.setStatus(e);
        }
        finally {
            h.complete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logMessageStats(CallstackStats callstackStats, MetricStats metricStats) {
        Heartbeat heartbeatMsg = this.producer.newHeartbeat("agent-stat", this.HOST_IP);
        try {
            HashMap<String, Map<String, Object>> stats = new HashMap<String, Map<String, Object>>();
            stats.put("message-stats", callstackStats.toStatMap());
            stats.put("metric-stats", metricStats.toStatMap());
            HashMap<String, String> migrationStats = new HashMap<String, String>();
            migrationStats.put("appid", AgentConfiguration.getAppId());
            migrationStats.put("version", "1.0-SNAPSHOT");
            stats.put("app-stats", migrationStats);
            heartbeatMsg.setData(JSONUtil.toString(stats));
            heartbeatMsg.setStatus("0");
        }
        catch (Throwable e) {
            this.monitorErrorInfo.put(this.LOG_THREAD_EXECUTOR, e.getMessage());
            heartbeatMsg.setStatus(e);
        }
        finally {
            if (this.monitorErrorInfo.size() > 0) {
                heartbeatMsg.addTags(this.monitorErrorInfo);
            }
            heartbeatMsg.complete();
        }
    }

    private void logThreadExecutor() {
        Heartbeat threadDump = this.producer.newHeartbeat("thread-dump", this.HOST_IP);
        try {
            threadDump.setData(JSONUtil.toString(this.jvmThreadExecutor.execute()));
            threadDump.setStatus("0");
        }
        catch (Throwable e) {
            this.monitorErrorInfo.put(this.LOG_THREAD_EXECUTOR, e.getMessage());
            threadDump.setStatus(e);
        }
        finally {
            threadDump.complete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mbeanInfo(String objectName, List<Pair<String, String>> attrs) {
        Heartbeat h = this.producer.newHeartbeat("MBean", objectName);
        try {
            for (Pair<String, String> attr : attrs) {
                h.addTag((String)attr.getKey(), (String)attr.getValue());
            }
            h.setStatus("0");
        }
        catch (Throwable e) {
            this.monitorErrorInfo.put(this.LOG_MBEAN_EXECUTOR, e.getMessage());
            h.setStatus(e);
        }
        finally {
            h.complete();
        }
    }

    private boolean internalSend(Message t) {
        boolean result = this.heartbeatQueue.produce(this.messageManager.getCurrentRequestId(), this.messageManager.getRpcId(), t);
        this.heartbeatStats.incTotalCount(1L);
        if (result) {
            this.heartbeatStats.incSuccessCount(1L);
        }
        this.messageManager.reset();
        return result;
    }
}

