/*
 * Decompiled with CFR 0.152.
 */
package io.etrace.agent.module;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import io.etrace.agent.module.AgentModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InjectorFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(InjectorFactory.class);
    private static InjectorFactory INSTANCE;
    private Injector injector;

    private InjectorFactory() {
        this.injector = Guice.createInjector((Module[])new Module[]{new AgentModule()});
    }

    private InjectorFactory(Injector injector) {
        this.injector = injector;
    }

    public static Injector getInjector() {
        if (INSTANCE == null) {
            INSTANCE = new InjectorFactory();
        }
        return InjectorFactory.INSTANCE.injector;
    }

    public static void setInjector(Injector injector) {
        if (INSTANCE == null) {
            INSTANCE = new InjectorFactory(injector);
        } else {
            LOGGER.error("==setInjector== ignore duplicate injector!");
        }
    }
}

