/*
 * Decompiled with CFR 0.152.
 */
package io.etrace.agent.module;

import com.google.inject.AbstractModule;
import com.google.inject.name.Names;
import io.etrace.agent.config.CollectorRegistry;
import io.etrace.agent.config.DefaultConfigManager;
import io.etrace.agent.io.MessageSender;
import io.etrace.agent.io.TcpMessageSender;
import io.etrace.agent.message.RequestIdAndRpcIdFactory;
import io.etrace.agent.message.callstack.CallstackProducer;
import io.etrace.agent.message.callstack.CallstackQueue;
import io.etrace.agent.message.manager.DefaultMessageManager;
import io.etrace.agent.message.metric.DefaultMetricManager;
import io.etrace.agent.message.metric.MetricProducer;
import io.etrace.agent.message.metric.MetricQueue;
import io.etrace.agent.stat.CallstackStats;
import io.etrace.agent.stat.MetricStats;
import io.etrace.common.message.ConfigManger;
import io.etrace.common.message.MessageManager;
import io.etrace.common.message.MetricManager;
import io.etrace.common.util.NetworkInterfaceHelper;
import java.lang.annotation.Annotation;

public class AgentModule
extends AbstractModule {
    protected void configure() {
        this.bind(CallstackProducer.class).asEagerSingleton();
        this.bind(MetricProducer.class).asEagerSingleton();
        this.bind(MessageManager.class).to(DefaultMessageManager.class).asEagerSingleton();
        this.bind(MetricManager.class).to(DefaultMetricManager.class).asEagerSingleton();
        this.bind(CallstackQueue.class).asEagerSingleton();
        this.bind(MetricQueue.class).asEagerSingleton();
        DefaultConfigManager configManger = new DefaultConfigManager();
        this.bind(ConfigManger.class).toInstance((Object)configManger);
        CollectorRegistry.getInstance().setConfigManger(configManger);
        CallstackStats callstackStats = new CallstackStats();
        this.bind(CallstackStats.class).toInstance((Object)callstackStats);
        this.bind(MessageSender.class).toInstance((Object)new TcpMessageSender("Trace", callstackStats.getTcpStats()));
        MetricStats metricStats = new MetricStats();
        this.bind(MetricStats.class).toInstance((Object)metricStats);
        TcpMessageSender metricSender = new TcpMessageSender("Metric", metricStats.getTcpStats());
        this.bind(MessageSender.class).annotatedWith((Annotation)Names.named((String)"metricTCPMessageSender")).toInstance((Object)metricSender);
        this.bind(RequestIdAndRpcIdFactory.class).asEagerSingleton();
        this.bindConstant().annotatedWith((Annotation)Names.named((String)"hostName")).to(NetworkInterfaceHelper.INSTANCE.getLocalHostName());
        this.bindConstant().annotatedWith((Annotation)Names.named((String)"hostIp")).to(NetworkInterfaceHelper.INSTANCE.getLocalHostAddress());
    }
}

