/*
 * Decompiled with CFR 0.152.
 */
package io.etrace.agent.message.metric;

import io.etrace.agent.message.metric.MetricQueue;
import io.etrace.common.message.ConfigManger;
import io.etrace.common.modal.metric.AbstractMetric;
import io.etrace.common.modal.metric.Metric;
import io.etrace.common.modal.metric.MetricKey;
import io.etrace.common.modal.metric.impl.HistogramImpl;
import io.etrace.common.modal.metric.impl.TimerImpl;
import java.util.HashMap;
import java.util.Map;

public class PackageMetric {
    protected MetricQueue.EventConsumer consumer;
    protected boolean isHistogram;
    protected String topic;
    protected Metric defaultMetric;
    protected Map<MetricKey, Metric> metrics;
    protected long count;
    protected int maxGroup;

    public PackageMetric(ConfigManger configManger, MetricQueue.EventConsumer consumer, Metric metric) {
        if (metric instanceof TimerImpl && ((TimerImpl)metric).isUpperEnable()) {
            this.isHistogram = true;
            this.maxGroup = configManger.getMetricConfig().getMaxHistogramGroup();
        } else {
            this.maxGroup = configManger.getMetricConfig().getMaxGroup();
            this.isHistogram = false;
        }
        if (metric instanceof AbstractMetric) {
            this.topic = ((AbstractMetric)metric).getTopic();
        }
        this.consumer = consumer;
    }

    private void addTagsMetric(Metric metric) {
        if (this.metrics == null) {
            this.metrics = new HashMap<MetricKey, Metric>();
            this.metrics.put(metric.getTagKey(), this.buildMetric(metric));
            ++this.count;
            ++this.consumer.sendCount;
            return;
        }
        MetricKey key = metric.getTagKey();
        Metric oldMetric = this.metrics.get(key);
        if (oldMetric == null) {
            if (this.count >= (long)this.maxGroup) {
                return;
            }
            ++this.count;
            ++this.consumer.sendCount;
            this.metrics.put(key, this.buildMetric(metric));
        } else {
            oldMetric.merge(metric);
            ++this.consumer.mergeCount;
        }
    }

    private Metric buildMetric(Metric metric) {
        if (this.isHistogram) {
            HistogramImpl histogram = new HistogramImpl(this.consumer.getBucketFunction());
            if (metric instanceof TimerImpl) {
                histogram.build((TimerImpl)metric);
                histogram.merge(metric);
            }
            return histogram;
        }
        return metric;
    }

    private void addDefault(Metric metric) {
        if (this.defaultMetric == null) {
            this.defaultMetric = this.buildMetric(metric);
            ++this.consumer.sendCount;
        } else {
            this.defaultMetric.merge(metric);
            ++this.consumer.mergeCount;
        }
    }

    public void merge(Metric metric) {
        if (metric.getTagKey() == null) {
            this.addDefault(metric);
        } else {
            this.addTagsMetric(metric);
        }
    }

    public boolean isEmpty() {
        return (this.metrics == null || this.metrics.size() <= 0) && this.defaultMetric == null;
    }

    public String getTopic() {
        return this.topic;
    }
}

