/*
 * Decompiled with CFR 0.152.
 */
package io.etrace.agent.message.metric;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.EventTranslatorOneArg;
import com.lmax.disruptor.EventTranslatorTwoArg;
import com.lmax.disruptor.TimeoutException;
import io.etrace.agent.config.AgentConfiguration;
import io.etrace.agent.io.MessageSender;
import io.etrace.agent.message.QueueContext;
import io.etrace.agent.message.callstack.CallstackQueue;
import io.etrace.agent.message.event.MatricPackageEvent;
import io.etrace.agent.message.event.MetricEvent;
import io.etrace.agent.message.metric.PackageMetric;
import io.etrace.agent.stat.MetricStats;
import io.etrace.common.histogram.BucketFunction;
import io.etrace.common.histogram.DistAlgorithmBucket;
import io.etrace.common.histogram.DistributionType;
import io.etrace.common.message.ConfigManger;
import io.etrace.common.modal.metric.Metric;
import io.etrace.common.modal.metric.MetricKey;
import io.etrace.common.util.ThreadUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class MetricQueue {
    private static final String SPLIT_STR = "##";
    protected QueueContext<MetricEvent> context = new QueueContext();
    protected QueueContext<MatricPackageEvent> packageContext;
    @Inject
    protected ConfigManger configManger;
    @Inject
    protected MetricStats stats;
    private MetricProducer metricProducer;
    private PackageProducer packageProducer;
    private BucketFunction bucketFunction;
    private ScheduledExecutorService executorService;
    @Inject
    @Named(value="metricTCPMessageSender")
    private MessageSender messageSender;

    public MetricQueue() {
        int bufferSize = 4096;
        this.metricProducer = new MetricProducer();
        MetricEvent.MetricEventFactory factory = new MetricEvent.MetricEventFactory();
        EventConsumer consumer = new EventConsumer();
        this.context.build("Metric-Producer", bufferSize, consumer, factory);
        this.packageContext = new QueueContext();
        int packageBufferSize = 16;
        this.packageProducer = new PackageProducer();
        MatricPackageEvent.PackageEventFactory packageFactory = new MatricPackageEvent.PackageEventFactory();
        this.packageContext.build("Metric-Package-Producer", packageBufferSize, new PackageConsumer(), packageFactory);
        this.executorService = new ScheduledThreadPoolExecutor(1, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("MetricQueue-Timer-%d").build());
        this.executorService.scheduleAtFixedRate(() -> {
            if (this.context.getRingBuffer() != null) {
                this.context.getRingBuffer().tryPublishEvent((EventTranslatorOneArg)this.metricProducer, null);
            }
        }, 0L, CallstackQueue.PULL_INTERVAL_IN_MILLISECOND, TimeUnit.MILLISECONDS);
        Runtime.getRuntime().addShutdownHook(new Thread(this::shutdown));
    }

    public void produce(Metric metric) {
        if (!this.context.isActive()) {
            return;
        }
        this.stats.incTotalCount();
        boolean success = this.context.getRingBuffer().tryPublishEvent((EventTranslatorOneArg)this.metricProducer, (Object)metric);
        if (!success) {
            for (int tryAgainCount = 0; !success && tryAgainCount < 2; ++tryAgainCount) {
                success = this.context.getRingBuffer().tryPublishEvent((EventTranslatorOneArg)this.metricProducer, (Object)metric);
            }
        }
        if (!success) {
            this.stats.incLoss();
            ThreadUtil.sleep((long)0L);
        }
    }

    public void shutdown() {
        try {
            this.context.setActive(false);
            this.context.getRingBuffer().tryPublishEvent((EventTranslatorOneArg)this.metricProducer, null);
            this.context.getDisruptor().shutdown(2L, TimeUnit.SECONDS);
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        this.executorService.shutdown();
    }

    public int getQueueSize() {
        return this.context.getQueueSize();
    }

    public int getPackageQueueSize() {
        return this.packageContext.getQueueSize();
    }

    class PackageConsumer
    implements EventHandler<MatricPackageEvent> {
        private int maxSize = 0x100000;
        private JsonFactory jsonFactory = new JsonFactory();
        private ByteArrayOutputStream baos = new ByteArrayOutputStream();
        private JsonGenerator generator;

        public PackageConsumer() {
            try {
                this.generator = this.jsonFactory.createJsonGenerator((OutputStream)this.baos, JsonEncoding.UTF8);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void onEvent(MatricPackageEvent event, long sequence, boolean endOfBatch) throws Exception {
            if (event.getMetrics() == null || event.getSendCount() <= 0) {
                event.clear();
                return;
            }
            Map<String, Map<MetricKey, PackageMetric>> metrics = event.getMetrics();
            HashMap<String, List> sendMetrics = new HashMap<String, List>();
            for (Map.Entry<String, Map<MetricKey, PackageMetric>> entry : metrics.entrySet()) {
                String name = entry.getKey();
                Map<MetricKey, PackageMetric> packageMetricMap = entry.getValue();
                if (packageMetricMap == null || packageMetricMap.isEmpty()) continue;
                for (PackageMetric packageMetric : entry.getValue().values()) {
                    if (packageMetric == null || packageMetric.isEmpty()) continue;
                    String key = packageMetric.getTopic() + MetricQueue.SPLIT_STR + name;
                    List packageMetrics = sendMetrics.computeIfAbsent(key, k -> new ArrayList());
                    packageMetrics.add(packageMetric);
                }
            }
            if (!sendMetrics.isEmpty()) {
                for (Map.Entry<String, Map<Object, PackageMetric>> entry : sendMetrics.entrySet()) {
                    try {
                        this.send(entry.getKey(), (List)((Object)entry.getValue()));
                    }
                    catch (Exception e) {
                        this.generator.flush();
                        this.generator.close();
                        this.baos.reset();
                        try {
                            this.generator = this.jsonFactory.createJsonGenerator((OutputStream)this.baos, JsonEncoding.UTF8);
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            event.clear();
        }

        private void flush(int sendCount, String key) throws IOException {
            this.generator.flush();
            if (this.baos != null && this.baos.size() > 0) {
                try {
                    if (sendCount > 0) {
                        MetricQueue.this.stats.incMergeAfterTotal(sendCount);
                        this.send(this.baos.toByteArray(), sendCount, key);
                    }
                }
                finally {
                    this.baos.reset();
                }
            }
        }

        private void send(String key, List<PackageMetric> metrics) throws IOException {
            int sendCount = 0;
            this.generator.writeStartArray();
            Iterator<PackageMetric> packageMetrics = metrics.iterator();
            while (packageMetrics.hasNext()) {
                PackageMetric packageMetric = packageMetrics.next();
                while (!packageMetric.isEmpty()) {
                    if ((sendCount = this.write(packageMetric, sendCount)) <= MetricQueue.this.configManger.getMetricConfig().getMaxPackageCount() && this.baos.size() < this.maxSize) continue;
                    this.generator.writeEndArray();
                    this.flush(sendCount, key);
                    sendCount = 0;
                    this.generator.writeStartArray();
                }
                packageMetrics.remove();
            }
            this.generator.writeEndArray();
            this.flush(sendCount, key);
        }

        private int write(PackageMetric packageMetric, int sendCount) throws IOException {
            this.generator.writeStartArray();
            this.generator.writeString("#v1#t2");
            this.generator.writeString(AgentConfiguration.getAppId());
            this.generator.writeString(MetricQueue.this.context.getHostIp());
            this.generator.writeString(MetricQueue.this.context.getHostName());
            this.generator.writeStartArray();
            if (packageMetric.defaultMetric != null) {
                this.generator.writeStartArray();
                packageMetric.defaultMetric.write(this.generator);
                this.generator.writeEndArray();
                packageMetric.defaultMetric = null;
                ++sendCount;
            }
            if (packageMetric.metrics != null && packageMetric.metrics.size() > 0) {
                Iterator<Metric> metricIterator = packageMetric.metrics.values().iterator();
                while (metricIterator.hasNext()) {
                    Metric metric = metricIterator.next();
                    if (metric == null) {
                        metricIterator.remove();
                        continue;
                    }
                    this.generator.writeStartArray();
                    metric.write(this.generator);
                    this.generator.writeEndArray();
                    metricIterator.remove();
                    if (++sendCount <= MetricQueue.this.configManger.getMetricConfig().getMaxPackageCount() && this.baos.size() < this.maxSize) continue;
                    break;
                }
            }
            this.generator.writeEndArray();
            this.generator.writeObject(MetricQueue.this.context.getExtraProperties());
            this.generator.writeEndArray();
            return sendCount;
        }

        protected void send(byte[] data, int sendCount, String key) {
            MetricQueue.this.messageSender.send(data, sendCount);
        }
    }

    class PackageProducer
    implements EventTranslatorTwoArg<MatricPackageEvent, Map<String, Map<MetricKey, PackageMetric>>, Integer> {
        PackageProducer() {
        }

        public void translateTo(MatricPackageEvent event, long sequence, Map<String, Map<MetricKey, PackageMetric>> metrics, Integer sendCount) {
            event.reset(metrics, sendCount == null ? 0 : sendCount);
        }
    }

    protected class EventConsumer
    implements EventHandler<MetricEvent> {
        protected int sendCount;
        protected int mergeCount;
        protected long start = System.currentTimeMillis();
        protected Map<String, Map<MetricKey, PackageMetric>> metrics = new HashMap<String, Map<MetricKey, PackageMetric>>();
        private int maxType = 15;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onEvent(MetricEvent event, long sequence, boolean endOfBatch) throws Exception {
            try {
                long endTime;
                Metric metric = event.getMetric();
                if (metric != null) {
                    PackageMetric oldMetric;
                    String name = metric.getName();
                    Map<MetricKey, PackageMetric> oldMetrics = this.metrics.get(name);
                    if (oldMetrics == null) {
                        if (this.metrics.size() >= MetricQueue.this.configManger.getMetricConfig().getMaxMetric()) {
                            return;
                        }
                        oldMetrics = new HashMap<MetricKey, PackageMetric>();
                        this.metrics.put(name, oldMetrics);
                    }
                    if ((oldMetric = oldMetrics.get(metric.getKey())) == null) {
                        if (oldMetrics.size() > this.maxType) {
                            return;
                        }
                        PackageMetric packageMetric = new PackageMetric(MetricQueue.this.configManger, this, metric);
                        packageMetric.merge(metric);
                        oldMetrics.put(metric.getKey(), packageMetric);
                    } else {
                        oldMetric.merge(metric);
                    }
                }
                if ((endTime = System.currentTimeMillis()) - this.start >= 2000L || this.sendCount > 150000 || !MetricQueue.this.context.isActive()) {
                    if (!this.tryPublishEvent()) {
                        MetricQueue.this.stats.incPackageLoss(this.sendCount + this.mergeCount);
                    } else {
                        MetricQueue.this.stats.incMerge(this.mergeCount);
                    }
                    this.metrics = new HashMap<String, Map<MetricKey, PackageMetric>>();
                    this.sendCount = 0;
                    this.mergeCount = 0;
                    this.start = System.currentTimeMillis();
                }
            }
            finally {
                event.clear();
            }
        }

        protected boolean tryPublishEvent() {
            return MetricQueue.this.packageContext.getRingBuffer().tryPublishEvent((EventTranslatorTwoArg)MetricQueue.this.packageProducer, this.metrics, (Object)this.sendCount);
        }

        public BucketFunction getBucketFunction() {
            if (MetricQueue.this.bucketFunction == null) {
                MetricQueue.this.bucketFunction = DistAlgorithmBucket.buildBucketFunction((DistributionType)DistributionType.Percentile, (long)0L);
            }
            return MetricQueue.this.bucketFunction;
        }
    }

    class MetricProducer
    implements EventTranslatorOneArg<MetricEvent, Metric> {
        MetricProducer() {
        }

        public void translateTo(MetricEvent event, long sequence, Metric metric) {
            event.reset(metric);
        }
    }
}

