/*
 * Decompiled with CFR 0.152.
 */
package io.etrace.agent.message.metric;

import com.google.inject.Inject;
import io.etrace.agent.config.AgentConfiguration;
import io.etrace.common.message.ConfigManger;
import io.etrace.common.message.MetricManager;
import io.etrace.common.modal.metric.AbstractMetric;
import io.etrace.common.modal.metric.Counter;
import io.etrace.common.modal.metric.Gauge;
import io.etrace.common.modal.metric.Payload;
import io.etrace.common.modal.metric.Timer;
import io.etrace.common.modal.metric.impl.CounterEmpty;
import io.etrace.common.modal.metric.impl.CounterImpl;
import io.etrace.common.modal.metric.impl.GaugeEmpty;
import io.etrace.common.modal.metric.impl.GaugeImpl;
import io.etrace.common.modal.metric.impl.PayloadEmpty;
import io.etrace.common.modal.metric.impl.PayloadImpl;
import io.etrace.common.modal.metric.impl.TimerEmpty;
import io.etrace.common.modal.metric.impl.TimerImpl;
import java.util.Map;

public class MetricProducer {
    private static Counter COUNTER_EMPTY = new CounterEmpty();
    private static Gauge GAUGE_EMPTY = new GaugeEmpty();
    private static Timer TIMER_EMPTY = new TimerEmpty();
    private static Payload PAYLOAD_EMPTY = new PayloadEmpty();
    private MetricManager metricManager;

    @Inject
    public MetricProducer(MetricManager metricManager) {
        this.metricManager = metricManager;
    }

    public Counter newCounter(String name) {
        ConfigManger configManger = this.metricManager.getConfigManager();
        if (!configManger.isEnabled() || !configManger.getMetricConfig().isEnabled()) {
            return COUNTER_EMPTY;
        }
        return (Counter)this.addGlobalTags(new CounterImpl(this.metricManager, name));
    }

    public Gauge newGauge(String name) {
        ConfigManger configManger = this.metricManager.getConfigManager();
        if (!configManger.isEnabled() || !configManger.getMetricConfig().isEnabled()) {
            return GAUGE_EMPTY;
        }
        return (Gauge)this.addGlobalTags(new GaugeImpl(this.metricManager, name));
    }

    public Timer newTimer(String name) {
        ConfigManger configManger = this.metricManager.getConfigManager();
        if (!configManger.isEnabled() || !configManger.getMetricConfig().isEnabled()) {
            return TIMER_EMPTY;
        }
        return (Timer)this.addGlobalTags(new TimerImpl(this.metricManager, name));
    }

    public Payload newPayload(String name) {
        ConfigManger configManger = this.metricManager.getConfigManager();
        if (!configManger.isEnabled() || !configManger.getMetricConfig().isEnabled()) {
            return PAYLOAD_EMPTY;
        }
        return (Payload)this.addGlobalTags(new PayloadImpl(this.metricManager, name));
    }

    private <T extends AbstractMetric> T addGlobalTags(T metric) {
        if (AgentConfiguration.getGlobalTags() != null) {
            for (Map.Entry<String, String> entry : AgentConfiguration.getGlobalTags().entrySet()) {
                metric.addTag(entry.getKey(), entry.getValue());
            }
        }
        return metric;
    }
}

