/*
 * Decompiled with CFR 0.152.
 */
package io.etrace.agent.message.manager;

import com.google.inject.Injector;
import io.etrace.agent.Trace;
import io.etrace.agent.message.RequestIdAndRpcIdFactory;
import io.etrace.agent.message.callstack.CallstackQueue;
import io.etrace.agent.message.manager.DefaultMessageManager;
import io.etrace.agent.message.manager.DefaultTraceContext;
import io.etrace.agent.module.InjectorFactory;
import io.etrace.common.message.ConfigManger;
import io.etrace.common.modal.TraceContext;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class MultiMessageManager
extends DefaultMessageManager {
    private TraceContext traceContext;
    private Lock lock = new ReentrantLock();
    private boolean isolated = false;

    private MultiMessageManager(CallstackQueue callstackQueue, RequestIdAndRpcIdFactory requestIdAndRpcIdFactory, ConfigManger configManger) {
        super(callstackQueue, requestIdAndRpcIdFactory, configManger, false);
        this.traceContext = new DefaultTraceContext(new DefaultMessageManager.Context(this));
    }

    public static MultiMessageManager createManager() {
        Injector injector = InjectorFactory.getInjector();
        CallstackQueue producer = (CallstackQueue)injector.getInstance(CallstackQueue.class);
        RequestIdAndRpcIdFactory requestIdAndRpcIdFactory = (RequestIdAndRpcIdFactory)injector.getInstance(RequestIdAndRpcIdFactory.class);
        ConfigManger configManger = (ConfigManger)injector.getInstance(ConfigManger.class);
        return new MultiMessageManager(producer, requestIdAndRpcIdFactory, configManger);
    }

    public void setIsolated(boolean isolated) {
        this.isolated = isolated;
    }

    @Override
    public void setup() {
    }

    @Override
    public void setup(String requestId, String rpcId) {
        if (this.traceContext != null && this.traceContext.getCtx() instanceof DefaultMessageManager.Context) {
            DefaultMessageManager.Context ctx = (DefaultMessageManager.Context)this.traceContext.getCtx();
            ctx.setup(requestId, rpcId);
        }
        if (!this.isolated) {
            Trace.continueTrace(requestId, rpcId);
        }
    }

    @Override
    public TraceContext exportContext() {
        this.lock.lock();
        try {
            if (this.traceContext != null) {
                TraceContext traceContext = this.traceContext;
                return traceContext;
            }
            TraceContext traceContext = super.exportContext();
            return traceContext;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean shouldLog(Throwable throwable) {
        DefaultMessageManager.Context ctx = this.traceContext == null ? null : (DefaultMessageManager.Context)this.traceContext.getCtx();
        return ctx == null || ctx.shouldLog(throwable);
    }

    @Override
    public void reset() {
        this.lock.lock();
        try {
            DefaultMessageManager.Context ctx;
            if (this.traceContext != null && this.traceContext.getCtx() instanceof DefaultMessageManager.Context && (ctx = (DefaultMessageManager.Context)this.traceContext.getCtx()) != null) {
                if (ctx.totalDuration == 0L) {
                    ctx.stack.clear();
                    ctx.knownExceptions.clear();
                    this.traceContext = null;
                } else {
                    ctx.knownExceptions.clear();
                }
            }
            if (!this.isolated) {
                if (Trace.isImportContext()) {
                    Trace.clean();
                }
                super.reset();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    protected DefaultMessageManager.Context getContext() {
        this.lock.lock();
        try {
            if (this.traceContext == null || !(this.traceContext.getCtx() instanceof DefaultMessageManager.Context)) {
                this.traceContext = new DefaultTraceContext(new DefaultMessageManager.Context(this));
            }
            DefaultMessageManager.Context context = (DefaultMessageManager.Context)this.traceContext.getCtx();
            return context;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void importContext(TraceContext ctx) {
        if (ctx != null && ctx.getCtx() instanceof DefaultMessageManager.Context) {
            DefaultMessageManager.Context curCtx = (DefaultMessageManager.Context)ctx.getCtx();
            this.traceContext = new DefaultTraceContext(curCtx);
        }
    }

    @Override
    public boolean hasTransaction() {
        if (this.traceContext == null) {
            return false;
        }
        DefaultMessageManager.Context context = (DefaultMessageManager.Context)this.traceContext.getCtx();
        return context.getRoot() != null;
    }
}

