/*
 * Decompiled with CFR 0.152.
 */
package io.etrace.agent.message.manager;

import com.google.common.base.Strings;
import com.google.inject.Inject;
import io.etrace.agent.config.AgentConfiguration;
import io.etrace.agent.message.RequestIdAndRpcIdFactory;
import io.etrace.agent.message.callstack.CallstackQueue;
import io.etrace.agent.message.manager.DefaultTraceContext;
import io.etrace.common.message.ConfigManger;
import io.etrace.common.message.MessageManager;
import io.etrace.common.modal.Message;
import io.etrace.common.modal.TraceContext;
import io.etrace.common.modal.Transaction;
import io.etrace.common.modal.impl.EventImpl;
import io.etrace.common.modal.impl.TransactionImpl;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Stack;

public class DefaultMessageManager
implements MessageManager {
    private CallstackQueue callstackQueue;
    private RequestIdAndRpcIdFactory requestIdAndRpcIdFactory;
    private ConfigManger configManger;
    private ThreadLocal<Context> contextThreadLocal;
    private ThreadLocal<Boolean> isImport = new ThreadLocal();

    @Inject
    public DefaultMessageManager(CallstackQueue callstackQueue, RequestIdAndRpcIdFactory requestIdAndRpcIdFactory, ConfigManger configManger) {
        this(callstackQueue, requestIdAndRpcIdFactory, configManger, true);
    }

    DefaultMessageManager(CallstackQueue callstackQueue, RequestIdAndRpcIdFactory requestIdAndRpcIdFactory, ConfigManger configManger, boolean createNewContext) {
        this.configManger = configManger;
        this.callstackQueue = callstackQueue;
        this.requestIdAndRpcIdFactory = requestIdAndRpcIdFactory;
        if (createNewContext) {
            this.contextThreadLocal = new ThreadLocal();
        }
    }

    public void addNonTransaction(Message message) {
        Context ctx = this.getContext();
        if (ctx != null) {
            ctx.add(message);
        }
    }

    public void endTransaction(Transaction transaction) {
        Context ctx = this.getContext();
        if (ctx != null && ctx.end(transaction)) {
            this.removeContext();
        }
    }

    public ConfigManger getConfigManager() {
        return this.configManger;
    }

    public void startTransaction(Transaction transaction) {
        Context ctx = this.getContext();
        if (ctx != null) {
            ctx.start(transaction);
        }
    }

    public void shutdown() {
        this.configManger.shutdown();
        this.callstackQueue.shutdown();
    }

    public boolean hasTransaction() {
        Context ctx = this.contextThreadLocal.get();
        if (ctx == null) {
            return false;
        }
        return ctx.getRoot() != null;
    }

    public void setup() {
        this.contextThreadLocal.set(new Context());
    }

    public void setup(String requestId, String rpcId) {
        this.contextThreadLocal.set(new Context(requestId, rpcId));
    }

    public TraceContext exportContext() {
        Context ctx = this.getContext();
        if (ctx != null) {
            return new DefaultTraceContext(ctx);
        }
        return null;
    }

    public void importContext(TraceContext ctx) {
        if (ctx != null && ctx.getCtx() instanceof Context) {
            this.contextThreadLocal.set((Context)ctx.getCtx());
            this.isImport.set(true);
        }
    }

    public String getClientAppId() {
        Context ctx = this.getContext();
        if (ctx != null) {
            return ctx.getClientAppId();
        }
        return "unknown";
    }

    public boolean hasContext() {
        return this.contextThreadLocal != null && this.contextThreadLocal.get() != null;
    }

    public boolean isImportContext() {
        return this.isImport.get() != null && this.isImport.get() != false;
    }

    public void reset() {
        Context ctx = this.getContext();
        if (ctx != null) {
            if (ctx.totalDuration == 0L) {
                ctx.stack.clear();
                ctx.knownExceptions.clear();
                this.removeContext();
            } else {
                ctx.knownExceptions.clear();
            }
        }
    }

    public void removeContext() {
        if (this.contextThreadLocal != null) {
            this.contextThreadLocal.remove();
        }
        this.isImport.remove();
    }

    public String nextRemoteRpcId() {
        Context ctx = this.getContext();
        if (ctx != null) {
            return ctx.nextRemoteRpcId();
        }
        return "1";
    }

    public String nextLocalRpcId() {
        String currentRpcId = this.getContext().rpcId;
        return RequestIdAndRpcIdFactory.buildNextLocalRpcId(currentRpcId, this.nextLocalThreadId());
    }

    public String getCurrentRequestId() {
        Context ctx = this.getContext();
        if (ctx != null) {
            return ctx.getCurrentRequestId();
        }
        return this.generateRequestId(null);
    }

    public String nextLocalThreadId() {
        Context ctx = this.getContext();
        if (ctx != null) {
            int nexLocalThreadId = ++ctx.nexLocalThreadId;
            return String.valueOf(nexLocalThreadId);
        }
        return String.valueOf(Thread.currentThread().getId());
    }

    public String getRpcId() {
        Context ctx = this.getContext();
        if (ctx != null) {
            return ctx.getRpcId();
        }
        return "1";
    }

    @Deprecated
    public String getCurrentRpcIdAndCurrentCall() {
        Context ctx = this.getContext();
        if (ctx != null) {
            return ctx.getCurrentRpcIdAndCurrentCall();
        }
        return "1";
    }

    public boolean shouldLog(Throwable throwable) {
        Context ctx = this.contextThreadLocal == null ? null : this.contextThreadLocal.get();
        return ctx == null || ctx.shouldLog(throwable);
    }

    private void flush(String requestId, String id, Message message) {
        this.callstackQueue.produce(requestId, id, message);
        this.reset();
    }

    protected Context getContext() {
        Context ctx = this.contextThreadLocal.get();
        if (ctx == null) {
            ctx = new Context();
            this.contextThreadLocal.set(ctx);
        }
        return ctx;
    }

    private String generateRequestId(String requestId) {
        return RequestIdAndRpcIdFactory.buildRequestId(Strings.isNullOrEmpty((String)requestId) ? this.requestIdAndRpcIdFactory.getNextId() : requestId, AgentConfiguration.getAppId());
    }

    public class Context {
        protected Stack<Transaction> stack = new Stack();
        protected Set<Throwable> knownExceptions = new HashSet<Throwable>();
        protected long totalDuration;
        protected int nexLocalThreadId = 0;
        private Message root;
        private int currentCall = 0;
        private String rpcId;
        private String requestId;
        private int next;
        private long totalChildren = 1L;
        private String clientAppId;

        public Context() {
            this(null, "1");
        }

        public Context(String requestId, String rpcId) {
            this.setup(requestId, rpcId);
        }

        public void setup(String requestId, String rpcId) {
            this.requestId = DefaultMessageManager.this.generateRequestId(requestId);
            if (Strings.isNullOrEmpty((String)rpcId)) {
                rpcId = "1";
            }
            this.clientAppId = RequestIdAndRpcIdFactory.parseClientAppIdFromOriginalRpcId(rpcId);
            this.rpcId = RequestIdAndRpcIdFactory.parseRpcIdFromOriginalRpcId(rpcId);
        }

        public String nextRemoteRpcId() {
            ++this.currentCall;
            return RequestIdAndRpcIdFactory.buildNextRemoteRpcId(this.rpcId, this.currentCall);
        }

        public String getClientAppId() {
            if (Strings.isNullOrEmpty((String)this.clientAppId)) {
                return "unknown";
            }
            return this.clientAppId;
        }

        public String getCurrentRequestId() {
            return this.requestId;
        }

        public String getRpcId() {
            return this.rpcId;
        }

        public String getCurrentRpcIdAndCurrentCall() {
            if (this.currentCall == 0) {
                return this.rpcId;
            }
            return RequestIdAndRpcIdFactory.buildNextRemoteRpcId(this.rpcId, this.currentCall);
        }

        public void add(Message message) {
            if (this.stack.isEmpty()) {
                DefaultMessageManager.this.flush(this.requestId, this.rpcId, message);
            } else {
                this.addChildren(this.stack.peek(), message);
            }
        }

        public boolean shouldLog(Throwable throwable) {
            if (this.knownExceptions == null) {
                this.knownExceptions = new HashSet<Throwable>();
            }
            if (this.knownExceptions.contains(throwable)) {
                return false;
            }
            this.knownExceptions.add(throwable);
            return true;
        }

        public void start(Transaction transaction) {
            if (this.stack.isEmpty()) {
                this.root = transaction;
            } else {
                this.addChildren(this.stack.peek(), (Message)transaction);
            }
            this.stack.push(transaction);
        }

        public boolean end(Transaction transaction) {
            if (this.stack != null && !this.stack.isEmpty()) {
                if (transaction.isBadTransaction() && transaction != this.root) {
                    return false;
                }
                Transaction current = this.stack.pop();
                if (current != transaction) {
                    while (transaction != current && !this.stack.isEmpty()) {
                        if (!current.isBadTransaction()) {
                            EventImpl event = new EventImpl("Trace", "BadTransaction");
                            event.setStatus("TransactionNotCompleted");
                            event.complete();
                            current.addChild((Message)event);
                        }
                        current = this.stack.pop();
                    }
                }
                if (this.stack.isEmpty()) {
                    if (this.totalDuration > 0L) {
                        this.totalDuration = 0L;
                    }
                    DefaultMessageManager.this.flush(this.requestId, this.rpcId, this.root);
                    return true;
                }
            }
            return false;
        }

        protected Message getRoot() {
            return this.root;
        }

        private void addChildren(Transaction parent, Message child) {
            if (this.totalChildren >= (long)DefaultMessageManager.this.configManger.getMessageCount()) {
                this.truncateAndFlush((Transaction)this.root);
                this.totalChildren = 1L;
                parent = (Transaction)this.root;
            }
            parent.addChild(child);
            ++this.totalChildren;
        }

        private void truncateAndFlush(Transaction parent) {
            String childId = RequestIdAndRpcIdFactory.buildTruncatedRpcId(this.rpcId, this.next);
            TransactionImpl target = new TransactionImpl("Trace", "Truncate");
            target.setStatus("0");
            EventImpl event = new EventImpl("Trace", "BadTransaction");
            event.setStatus("TransactionLongerChildren");
            event.complete();
            target.addChild((Message)event);
            List children = parent.getChildren();
            Iterator it = children.iterator();
            ArrayList<Object> truncateEvents = new ArrayList<Object>();
            while (it.hasNext()) {
                Message message = (Message)it.next();
                if (!"ETraceLink".equals(message.getType()) || !"Truncate".equals(message.getName())) {
                    if (!message.isCompleted()) {
                        message.complete();
                    }
                    target.addChild(message);
                    continue;
                }
                truncateEvents.add(message);
            }
            if (truncateEvents.size() > 100) {
                for (Message message : truncateEvents) {
                    target.addChild(message);
                }
                truncateEvents.clear();
            }
            ++this.next;
            this.totalDuration = 1L;
            DefaultMessageManager.this.flush(this.getCurrentRequestId(), childId, (Message)target);
            EventImpl next = new EventImpl("ETraceLink", "Truncate");
            next.setData(childId);
            next.setStatus("0");
            parent.setChildren(truncateEvents);
            parent.addChild((Message)next);
        }
    }
}

