/*
 * Decompiled with CFR 0.152.
 */
package io.etrace.agent.message.heartbeat;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.google.inject.Inject;
import io.etrace.agent.config.AgentConfiguration;
import io.etrace.agent.io.MessageSender;
import io.etrace.common.modal.CallStackV1;
import io.etrace.common.modal.JSONCodecV1;
import io.etrace.common.modal.Message;
import io.etrace.common.util.NetworkInterfaceHelper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class HeartbeatQueue {
    @Inject
    private MessageSender messageSender;
    private String hostIp = NetworkInterfaceHelper.INSTANCE.getLocalHostAddress();
    private String hostName = NetworkInterfaceHelper.INSTANCE.getLocalHostName();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean produce(String requestId, String rpcId, Message message) {
        ByteArrayOutputStream baos = null;
        try {
            CallStackV1 callStack = new CallStackV1(AgentConfiguration.getAppId(), this.hostIp, this.hostName, requestId, rpcId, message, AgentConfiguration.getExtraProperties());
            JsonFactory jsonFactory = new JsonFactory();
            JsonGenerator generator = null;
            try {
                baos = new ByteArrayOutputStream();
                generator = jsonFactory.createGenerator((OutputStream)baos, JsonEncoding.UTF8);
                generator.writeStartArray();
                JSONCodecV1.encodeCallstackByArrayFormat((CallStackV1)callStack, (JsonGenerator)generator);
            }
            catch (IOException iOException) {
            }
            finally {
                if (generator != null) {
                    try {
                        generator.writeEndArray();
                        generator.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            this.messageSender.send(baos.toByteArray(), 1);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }
}

